/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.amazonaws.util.json.JSONArray;
import com.amazonaws.util.json.JSONException;
import com.amazonaws.util.json.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class JSONTokener {
    private int character;
    private boolean eof;
    private int index;
    private int line;
    private char previous;
    private Reader reader;
    private boolean usePrevious;

    public JSONTokener(Reader reader) {
        this.reader = reader.markSupported() ? reader : new BufferedReader(reader);
        this.eof = false;
        this.usePrevious = false;
        this.previous = '\u0000';
        this.index = 0;
        this.character = 1;
        this.line = 1;
    }

    public JSONTokener(String s2) {
        this(new StringReader(s2));
    }

    public void back() {
        if (this.usePrevious || this.index <= 0) {
            throw new JSONException("Stepping back two steps is not supported");
        }
        --this.index;
        --this.character;
        this.usePrevious = true;
        this.eof = false;
    }

    public static int dehexchar(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 55;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 87;
        }
        return -1;
    }

    public boolean end() {
        return this.eof && !this.usePrevious;
    }

    public boolean more() {
        this.next();
        if (this.end()) {
            return false;
        }
        this.back();
        return true;
    }

    public char next() {
        int c2;
        if (this.usePrevious) {
            this.usePrevious = false;
            c2 = this.previous;
        } else {
            try {
                c2 = this.reader.read();
            }
            catch (IOException exception) {
                throw new JSONException(exception);
            }
            if (c2 <= 0) {
                this.eof = true;
                c2 = 0;
            }
        }
        ++this.index;
        if (this.previous == '\r') {
            ++this.line;
            this.character = c2 == 10 ? 0 : 1;
        } else if (c2 == 10) {
            ++this.line;
            this.character = 0;
        } else {
            ++this.character;
        }
        this.previous = (char)c2;
        return this.previous;
    }

    public char next(char c2) {
        char n2 = this.next();
        if (n2 != c2) {
            throw this.syntaxError("Expected '" + c2 + "' and instead saw '" + n2 + "'");
        }
        return n2;
    }

    public String next(int n2) {
        if (n2 == 0) {
            return "";
        }
        char[] buffer = new char[n2];
        for (int pos = 0; pos < n2; ++pos) {
            buffer[pos] = this.next();
            if (!this.end()) continue;
            throw this.syntaxError("Substring bounds error");
        }
        return new String(buffer);
    }

    public char nextClean() {
        char c2;
        while ((c2 = this.next()) != '\u0000' && c2 <= ' ') {
        }
        return c2;
    }

    public String nextString(char quote) {
        StringBuffer sb2 = new StringBuffer();
        block13: while (true) {
            char c2 = this.next();
            switch (c2) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    c2 = this.next();
                    switch (c2) {
                        case 'b': {
                            sb2.append('\b');
                            continue block13;
                        }
                        case 't': {
                            sb2.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            sb2.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            sb2.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            sb2.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            sb2.append((char)Integer.parseInt(this.next(4), 16));
                            continue block13;
                        }
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            sb2.append(c2);
                            continue block13;
                        }
                    }
                    throw this.syntaxError("Illegal escape.");
                }
            }
            if (c2 == quote) {
                return sb2.toString();
            }
            sb2.append(c2);
        }
    }

    public String nextTo(char d2) {
        StringBuffer sb2 = new StringBuffer();
        while (true) {
            char c2;
            if ((c2 = this.next()) == d2 || c2 == '\u0000' || c2 == '\n' || c2 == '\r') {
                if (c2 != '\u0000') {
                    this.back();
                }
                return sb2.toString().trim();
            }
            sb2.append(c2);
        }
    }

    public String nextTo(String delimiters) {
        StringBuffer sb2 = new StringBuffer();
        while (true) {
            char c2;
            if (delimiters.indexOf(c2 = this.next()) >= 0 || c2 == '\u0000' || c2 == '\n' || c2 == '\r') {
                if (c2 != '\u0000') {
                    this.back();
                }
                return sb2.toString().trim();
            }
            sb2.append(c2);
        }
    }

    public Object nextValue() {
        char c2 = this.nextClean();
        switch (c2) {
            case '\"': 
            case '\'': {
                return this.nextString(c2);
            }
            case '{': {
                this.back();
                return new JSONObject(this);
            }
            case '(': 
            case '[': {
                this.back();
                return new JSONArray(this);
            }
        }
        StringBuffer sb2 = new StringBuffer();
        while (c2 >= ' ' && ",:]}/\\\"[{;=#".indexOf(c2) < 0) {
            sb2.append(c2);
            c2 = this.next();
        }
        this.back();
        String s2 = sb2.toString().trim();
        if (s2.equals("")) {
            throw this.syntaxError("Missing value");
        }
        return JSONObject.stringToValue(s2);
    }

    public char skipTo(char to2) {
        char c2;
        try {
            int startIndex = this.index;
            int startCharacter = this.character;
            int startLine = this.line;
            this.reader.mark(Integer.MAX_VALUE);
            do {
                if ((c2 = this.next()) != '\u0000') continue;
                this.reader.reset();
                this.index = startIndex;
                this.character = startCharacter;
                this.line = startLine;
                return c2;
            } while (c2 != to2);
        }
        catch (IOException exc) {
            throw new JSONException(exc);
        }
        this.back();
        return c2;
    }

    public JSONException syntaxError(String message) {
        return new JSONException(message + this.toString());
    }

    public String toString() {
        return " at " + this.index + " [character " + this.character + " line " + this.line + "]";
    }
}

