/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.AbortedException;
import com.amazonaws.AmazonClientException;
import org.apache.commons.logging.LogFactory;

public enum Throwables {


    public static Throwable getRootCause(Throwable orig) {
        if (orig == null) {
            return orig;
        }
        Throwable t2 = orig;
        for (int i2 = 0; i2 < 1000; ++i2) {
            Throwable cause = t2.getCause();
            if (cause == null) {
                return t2;
            }
            t2 = cause;
        }
        LogFactory.getLog(Throwables.class).debug("Possible circular reference detected on " + orig.getClass() + ": [" + orig + "]");
        return orig;
    }

    public static RuntimeException failure(Throwable t2) {
        if (t2 instanceof RuntimeException) {
            return (RuntimeException)t2;
        }
        if (t2 instanceof Error) {
            throw (Error)t2;
        }
        return t2 instanceof InterruptedException ? new AbortedException(t2) : new AmazonClientException(t2);
    }

    public static RuntimeException failure(Throwable t2, String errmsg) {
        if (t2 instanceof RuntimeException) {
            return (RuntimeException)t2;
        }
        if (t2 instanceof Error) {
            throw (Error)t2;
        }
        return t2 instanceof InterruptedException ? new AbortedException(errmsg, t2) : new AmazonClientException(errmsg, t2);
    }
}

