/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.internal.Releasable;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum IOUtils {

    private static final int BUFFER_SIZE = 4096;
    private static final Log defaultLog = LogFactory.getLog(IOUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream is2) {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            byte[] b2 = new byte[4096];
            int n2 = 0;
            while ((n2 = is2.read(b2)) != -1) {
                output.write(b2, 0, n2);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static String toString(InputStream is2) {
        return new String(IOUtils.toByteArray(is2), StringUtils.UTF8);
    }

    public static void closeQuietly(Closeable is2, Log log) {
        block3: {
            if (is2 != null) {
                try {
                    is2.close();
                }
                catch (IOException ex2) {
                    Log logger;
                    Log log2 = logger = log == null ? defaultLog : log;
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Ignore failure in closing the Closeable", ex2);
                }
            }
        }
    }

    public static void release(Closeable is2, Log log) {
        IOUtils.closeQuietly(is2, log);
        if (is2 instanceof Releasable) {
            Releasable r2 = (Releasable)((Object)is2);
            r2.release();
        }
    }
}

