/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.EC2MetadataUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EC2MetadataUtils$NetworkInterface {
    private String path;
    private String mac;
    private List<String> availableKeys;
    private Map<String, String> data = new HashMap<String, String>();

    public EC2MetadataUtils$NetworkInterface(String macAddress) {
        this.mac = macAddress;
        this.path = "/network/interfaces/macs/" + this.mac + "/";
    }

    public String getMacAddress() {
        return this.mac;
    }

    public String getOwnerId() {
        return this.getData("owner-id");
    }

    public String getProfile() {
        return this.getData("profile");
    }

    public String getHostname() {
        return this.getData("local-hostname");
    }

    public List<String> getLocalIPv4s() {
        return this.getItems("local-ipv4s");
    }

    public String getPublicHostname() {
        return this.getData("public-hostname");
    }

    public List<String> getPublicIPv4s() {
        return this.getItems("public-ipv4s");
    }

    public List<String> getSecurityGroups() {
        return this.getItems("security-groups");
    }

    public List<String> getSecurityGroupIds() {
        return this.getItems("security-group-ids");
    }

    public String getSubnetIPv4CidrBlock() {
        return this.getData("subnet-ipv4-cidr-block");
    }

    public String getVpcId() {
        return this.getData("vpc-id");
    }

    public List<String> getIPv4Association(String publicIp) {
        return EC2MetadataUtils.getItems("/latest/meta-data" + this.path + "ipv4-associations/" + publicIp);
    }

    private String getData(String key) {
        if (this.data.containsKey(key)) {
            return this.data.get(key);
        }
        if (null == this.availableKeys) {
            this.availableKeys = EC2MetadataUtils.getItems("/latest/meta-data" + this.path);
        }
        if (this.availableKeys.contains(key)) {
            this.data.put(key, EC2MetadataUtils.getData("/latest/meta-data" + this.path + key));
            return this.data.get(key);
        }
        return null;
    }

    private List<String> getItems(String key) {
        if (null == this.availableKeys) {
            this.availableKeys = EC2MetadataUtils.getItems("/latest/meta-data" + this.path);
        }
        if (this.availableKeys.contains(key)) {
            return EC2MetadataUtils.getItems("/latest/meta-data" + this.path + key);
        }
        return new LinkedList<String>();
    }
}

