/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.Base64;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Locale;

public class BinaryUtils {
    public static String toHex(byte[] data) {
        StringBuilder sb2 = new StringBuilder(data.length * 2);
        for (int i2 = 0; i2 < data.length; ++i2) {
            String hex = Integer.toHexString(data[i2]);
            if (hex.length() == 1) {
                sb2.append("0");
            } else if (hex.length() == 8) {
                hex = hex.substring(6);
            }
            sb2.append(hex);
        }
        return sb2.toString().toLowerCase(Locale.getDefault());
    }

    public static byte[] fromHex(String hexData) {
        byte[] result = new byte[(hexData.length() + 1) / 2];
        String hexNumber = null;
        int byteOffset = 0;
        for (int stringOffset = 0; stringOffset < hexData.length(); stringOffset += 2) {
            hexNumber = hexData.substring(stringOffset, stringOffset + 2);
            result[byteOffset++] = (byte)Integer.parseInt(hexNumber, 16);
        }
        return result;
    }

    public static String toBase64(byte[] data) {
        return Base64.encodeAsString(data);
    }

    public static byte[] fromBase64(String b64Data) {
        return b64Data == null ? null : Base64.decode(b64Data);
    }

    @Deprecated
    public static ByteArrayInputStream toStream(ByteBuffer byteBuffer) {
        return new ByteArrayInputStream(BinaryUtils.copyBytesFrom(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] copyAllBytesFrom(ByteBuffer bb2) {
        if (bb2 == null) {
            return null;
        }
        if (bb2.hasArray()) {
            return Arrays.copyOf(bb2.array(), bb2.limit());
        }
        bb2.mark();
        int marked = bb2.position();
        try {
            byte[] dst = new byte[bb2.rewind().remaining()];
            bb2.get(dst);
            byte[] byArray = dst;
            return byArray;
        }
        finally {
            bb2.position(marked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] copyBytesFrom(ByteBuffer bb2) {
        if (bb2 == null) {
            return null;
        }
        if (bb2.hasArray()) {
            return Arrays.copyOfRange(bb2.array(), bb2.position(), bb2.limit());
        }
        bb2.mark();
        try {
            byte[] dst = new byte[bb2.remaining()];
            bb2.get(dst);
            byte[] byArray = dst;
            return byArray;
        }
        finally {
            bb2.reset();
        }
    }
}

