/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.Base64Codec$LazyHolder;
import com.amazonaws.util.Codec;
import com.amazonaws.util.CodecUtils;

class Base64Codec
implements Codec {
    private static final int OFFSET_OF_a = 71;
    private static final int OFFSET_OF_0 = -4;
    private static final int OFFSET_OF_PLUS = -19;
    private static final int OFFSET_OF_SLASH = -16;
    private static final int MASK_2BITS = 3;
    private static final int MASK_4BITS = 15;
    private static final int MASK_6BITS = 63;
    private static final byte PAD = 61;
    private final byte[] ALPAHBETS;

    Base64Codec() {
        this.ALPAHBETS = CodecUtils.toBytesDirect("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
    }

    protected Base64Codec(byte[] alphabets) {
        this.ALPAHBETS = alphabets;
    }

    @Override
    public byte[] encode(byte[] src) {
        int num3bytes = src.length / 3;
        int remainder = src.length % 3;
        if (remainder == 0) {
            byte[] dest = new byte[num3bytes * 4];
            int s2 = 0;
            int d2 = 0;
            while (s2 < src.length) {
                this.encode3bytes(src, s2, dest, d2);
                s2 += 3;
                d2 += 4;
            }
            return dest;
        }
        byte[] dest = new byte[(num3bytes + 1) * 4];
        int s3 = 0;
        int d3 = 0;
        while (s3 < src.length - remainder) {
            this.encode3bytes(src, s3, dest, d3);
            s3 += 3;
            d3 += 4;
        }
        switch (remainder) {
            case 1: {
                this.encode1byte(src, s3, dest, d3);
                break;
            }
            case 2: {
                this.encode2bytes(src, s3, dest, d3);
            }
        }
        return dest;
    }

    void encode3bytes(byte[] src, int s2, byte[] dest, int d2) {
        int n2 = d2++;
        byte p2 = src[s2++];
        dest[n2] = this.ALPAHBETS[p2 >>> 2 & 0x3F];
        int n3 = d2++;
        int n4 = (p2 & 3) << 4;
        p2 = src[s2++];
        dest[n3] = this.ALPAHBETS[n4 | p2 >>> 4 & 0xF];
        int n5 = d2++;
        int n6 = (p2 & 0xF) << 2;
        p2 = src[s2];
        dest[n5] = this.ALPAHBETS[n6 | p2 >>> 6 & 3];
        dest[d2] = this.ALPAHBETS[p2 & 0x3F];
    }

    void encode2bytes(byte[] src, int s2, byte[] dest, int d2) {
        int n2 = d2++;
        byte p2 = src[s2++];
        dest[n2] = this.ALPAHBETS[p2 >>> 2 & 0x3F];
        int n3 = d2++;
        int n4 = (p2 & 3) << 4;
        p2 = src[s2];
        dest[n3] = this.ALPAHBETS[n4 | p2 >>> 4 & 0xF];
        dest[d2++] = this.ALPAHBETS[(p2 & 0xF) << 2];
        dest[d2] = 61;
    }

    void encode1byte(byte[] src, int s2, byte[] dest, int d2) {
        int n2 = d2++;
        byte p2 = src[s2];
        dest[n2] = this.ALPAHBETS[p2 >>> 2 & 0x3F];
        dest[d2++] = this.ALPAHBETS[(p2 & 3) << 4];
        dest[d2++] = 61;
        dest[d2] = 61;
    }

    void decode4bytes(byte[] src, int s2, byte[] dest, int d2) {
        int p2 = 0;
        int n2 = d2++;
        int n3 = s2++;
        p2 = this.pos(src[s2++]);
        dest[n2] = (byte)(this.pos(src[n3]) << 2 | p2 >>> 4 & 3);
        int n4 = d2++;
        int n5 = (p2 & 0xF) << 4;
        p2 = this.pos(src[s2++]);
        dest[n4] = (byte)(n5 | p2 >>> 2 & 0xF);
        dest[d2] = (byte)((p2 & 3) << 6 | this.pos(src[s2]));
    }

    void decode1to3bytes(int n2, byte[] src, int s2, byte[] dest, int d2) {
        int p2 = 0;
        int n3 = d2++;
        int n4 = s2++;
        p2 = this.pos(src[s2++]);
        dest[n3] = (byte)(this.pos(src[n4]) << 2 | p2 >>> 4 & 3);
        if (n2 == 1) {
            CodecUtils.sanityCheckLastPos(p2, 15);
            return;
        }
        int n5 = d2++;
        int n6 = (p2 & 0xF) << 4;
        p2 = this.pos(src[s2++]);
        dest[n5] = (byte)(n6 | p2 >>> 2 & 0xF);
        if (n2 == 2) {
            CodecUtils.sanityCheckLastPos(p2, 3);
            return;
        }
        dest[d2] = (byte)((p2 & 3) << 6 | this.pos(src[s2]));
    }

    @Override
    public byte[] decode(byte[] src, int length) {
        int d2;
        int fq2;
        if (length % 4 != 0) {
            throw new IllegalArgumentException("Input is expected to be encoded in multiple of 4 bytes but found: " + length);
        }
        int pads = 0;
        for (int last = length - 1; pads < 2 && last > -1 && src[last] == 61; --last, ++pads) {
        }
        switch (pads) {
            case 0: {
                fq2 = 3;
                break;
            }
            case 1: {
                fq2 = 2;
                break;
            }
            case 2: {
                fq2 = 1;
                break;
            }
            default: {
                throw new Error("Impossible");
            }
        }
        byte[] dest = new byte[length / 4 * 3 - (3 - fq2)];
        int s2 = 0;
        for (d2 = 0; d2 < dest.length - fq2 % 3; d2 += 3) {
            this.decode4bytes(src, s2, dest, d2);
            s2 += 4;
        }
        if (fq2 < 3) {
            this.decode1to3bytes(fq2, src, s2, dest, d2);
        }
        return dest;
    }

    protected int pos(byte in2) {
        byte pos = Base64Codec$LazyHolder.access$000()[in2];
        if (pos > -1) {
            return pos;
        }
        throw new IllegalArgumentException("Invalid base 64 character: '" + (char)in2 + "'");
    }
}

