/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.Codec;
import com.amazonaws.util.CodecUtils;

abstract class AbstractBase32Codec
implements Codec {
    private static final int MASK_2BITS = 3;
    private static final int MASK_3BITS = 7;
    private static final int MASK_4BITS = 15;
    private static final int MASK_5BITS = 31;
    private static final byte PAD = 61;
    private final byte[] ALPAHBETS;

    protected AbstractBase32Codec(byte[] alphabets) {
        this.ALPAHBETS = alphabets;
    }

    @Override
    public final byte[] encode(byte[] src) {
        int num5bytes = src.length / 5;
        int remainder = src.length % 5;
        if (remainder == 0) {
            byte[] dest = new byte[num5bytes * 8];
            int s2 = 0;
            int d2 = 0;
            while (s2 < src.length) {
                this.encode5bytes(src, s2, dest, d2);
                s2 += 5;
                d2 += 8;
            }
            return dest;
        }
        byte[] dest = new byte[(num5bytes + 1) * 8];
        int s3 = 0;
        int d3 = 0;
        while (s3 < src.length - remainder) {
            this.encode5bytes(src, s3, dest, d3);
            s3 += 5;
            d3 += 8;
        }
        switch (remainder) {
            case 1: {
                this.encode1byte(src, s3, dest, d3);
                break;
            }
            case 2: {
                this.encode2bytes(src, s3, dest, d3);
                break;
            }
            case 3: {
                this.encode3bytes(src, s3, dest, d3);
                break;
            }
            case 4: {
                this.encode4bytes(src, s3, dest, d3);
            }
        }
        return dest;
    }

    private final void encode5bytes(byte[] src, int s2, byte[] dest, int d2) {
        int n2 = d2++;
        byte p2 = src[s2++];
        dest[n2] = this.ALPAHBETS[p2 >>> 3 & 0x1F];
        int n3 = d2++;
        int n4 = (p2 & 7) << 2;
        p2 = src[s2++];
        dest[n3] = this.ALPAHBETS[n4 | p2 >>> 6 & 3];
        dest[d2++] = this.ALPAHBETS[p2 >>> 1 & 0x1F];
        int n5 = d2++;
        int n6 = (p2 & 1) << 4;
        p2 = src[s2++];
        dest[n5] = this.ALPAHBETS[n6 | p2 >>> 4 & 0xF];
        int n7 = d2++;
        int n8 = (p2 & 0xF) << 1;
        p2 = src[s2++];
        dest[n7] = this.ALPAHBETS[n8 | p2 >>> 7 & 1];
        dest[d2++] = this.ALPAHBETS[p2 >>> 2 & 0x1F];
        int n9 = d2++;
        int n10 = (p2 & 3) << 3;
        p2 = src[s2];
        dest[n9] = this.ALPAHBETS[n10 | p2 >>> 5 & 7];
        dest[d2] = this.ALPAHBETS[p2 & 0x1F];
    }

    private final void encode4bytes(byte[] src, int s2, byte[] dest, int d2) {
        int n2 = d2++;
        byte p2 = src[s2++];
        dest[n2] = this.ALPAHBETS[p2 >>> 3 & 0x1F];
        int n3 = d2++;
        int n4 = (p2 & 7) << 2;
        p2 = src[s2++];
        dest[n3] = this.ALPAHBETS[n4 | p2 >>> 6 & 3];
        dest[d2++] = this.ALPAHBETS[p2 >>> 1 & 0x1F];
        int n5 = d2++;
        int n6 = (p2 & 1) << 4;
        p2 = src[s2++];
        dest[n5] = this.ALPAHBETS[n6 | p2 >>> 4 & 0xF];
        int n7 = d2++;
        int n8 = (p2 & 0xF) << 1;
        p2 = src[s2];
        dest[n7] = this.ALPAHBETS[n8 | p2 >>> 7 & 1];
        dest[d2++] = this.ALPAHBETS[p2 >>> 2 & 0x1F];
        dest[d2++] = this.ALPAHBETS[(p2 & 3) << 3];
        dest[d2] = 61;
    }

    private final void encode3bytes(byte[] src, int s2, byte[] dest, int d2) {
        int n2 = d2++;
        byte p2 = src[s2++];
        dest[n2] = this.ALPAHBETS[p2 >>> 3 & 0x1F];
        int n3 = d2++;
        int n4 = (p2 & 7) << 2;
        p2 = src[s2++];
        dest[n3] = this.ALPAHBETS[n4 | p2 >>> 6 & 3];
        dest[d2++] = this.ALPAHBETS[p2 >>> 1 & 0x1F];
        int n5 = d2++;
        int n6 = (p2 & 1) << 4;
        p2 = src[s2];
        dest[n5] = this.ALPAHBETS[n6 | p2 >>> 4 & 0xF];
        dest[d2++] = this.ALPAHBETS[(p2 & 0xF) << 1];
        for (int i2 = 0; i2 < 3; ++i2) {
            dest[d2++] = 61;
        }
    }

    private final void encode2bytes(byte[] src, int s2, byte[] dest, int d2) {
        int n2 = d2++;
        byte p2 = src[s2++];
        dest[n2] = this.ALPAHBETS[p2 >>> 3 & 0x1F];
        int n3 = d2++;
        int n4 = (p2 & 7) << 2;
        p2 = src[s2];
        dest[n3] = this.ALPAHBETS[n4 | p2 >>> 6 & 3];
        dest[d2++] = this.ALPAHBETS[p2 >>> 1 & 0x1F];
        dest[d2++] = this.ALPAHBETS[(p2 & 1) << 4];
        for (int i2 = 0; i2 < 4; ++i2) {
            dest[d2++] = 61;
        }
    }

    private final void encode1byte(byte[] src, int s2, byte[] dest, int d2) {
        int n2 = d2++;
        byte p2 = src[s2];
        dest[n2] = this.ALPAHBETS[p2 >>> 3 & 0x1F];
        dest[d2++] = this.ALPAHBETS[(p2 & 7) << 2];
        for (int i2 = 0; i2 < 6; ++i2) {
            dest[d2++] = 61;
        }
    }

    private final void decode5bytes(byte[] src, int s2, byte[] dest, int d2) {
        int p2 = 0;
        int n2 = d2++;
        int n3 = s2++;
        p2 = this.pos(src[s2++]);
        dest[n2] = (byte)(this.pos(src[n3]) << 3 | p2 >>> 2 & 7);
        int n4 = d2++;
        int n5 = (p2 & 3) << 6 | this.pos(src[s2++]) << 1;
        p2 = this.pos(src[s2++]);
        dest[n4] = (byte)(n5 | p2 >>> 4 & 1);
        int n6 = d2++;
        int n7 = (p2 & 0xF) << 4;
        p2 = this.pos(src[s2++]);
        dest[n6] = (byte)(n7 | p2 >>> 1 & 0xF);
        int n8 = d2++;
        int n9 = (p2 & 1) << 7 | this.pos(src[s2++]) << 2;
        p2 = this.pos(src[s2++]);
        dest[n8] = (byte)(n9 | p2 >>> 3 & 3);
        dest[d2] = (byte)((p2 & 7) << 5 | this.pos(src[s2]));
    }

    private final void decode1to4bytes(int n2, byte[] src, int s2, byte[] dest, int d2) {
        int p2 = 0;
        int n3 = d2++;
        int n4 = s2++;
        p2 = this.pos(src[s2++]);
        dest[n3] = (byte)(this.pos(src[n4]) << 3 | p2 >>> 2 & 7);
        if (n2 == 1) {
            CodecUtils.sanityCheckLastPos(p2, 3);
            return;
        }
        int n5 = d2++;
        int n6 = (p2 & 3) << 6 | this.pos(src[s2++]) << 1;
        p2 = this.pos(src[s2++]);
        dest[n5] = (byte)(n6 | p2 >>> 4 & 1);
        if (n2 == 2) {
            CodecUtils.sanityCheckLastPos(p2, 15);
            return;
        }
        int n7 = d2++;
        int n8 = (p2 & 0xF) << 4;
        p2 = this.pos(src[s2++]);
        dest[n7] = (byte)(n8 | p2 >>> 1 & 0xF);
        if (n2 == 3) {
            CodecUtils.sanityCheckLastPos(p2, 1);
            return;
        }
        int n9 = (p2 & 1) << 7 | this.pos(src[s2++]) << 2;
        p2 = this.pos(src[s2]);
        dest[d2] = (byte)(n9 | p2 >>> 3 & 3);
        CodecUtils.sanityCheckLastPos(p2, 7);
    }

    @Override
    public final byte[] decode(byte[] src, int length) {
        int d2;
        int fq2;
        if (length % 8 != 0) {
            throw new IllegalArgumentException("Input is expected to be encoded in multiple of 8 bytes but found: " + length);
        }
        int pads = 0;
        for (int last = length - 1; pads < 6 && last > -1 && src[last] == 61; --last, ++pads) {
        }
        switch (pads) {
            case 0: {
                fq2 = 5;
                break;
            }
            case 1: {
                fq2 = 4;
                break;
            }
            case 3: {
                fq2 = 3;
                break;
            }
            case 4: {
                fq2 = 2;
                break;
            }
            case 6: {
                fq2 = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid number of paddings " + pads);
            }
        }
        byte[] dest = new byte[length / 8 * 5 - (5 - fq2)];
        int s2 = 0;
        for (d2 = 0; d2 < dest.length - fq2 % 5; d2 += 5) {
            this.decode5bytes(src, s2, dest, d2);
            s2 += 8;
        }
        if (fq2 < 5) {
            this.decode1to4bytes(fq2, src, s2, dest, d2);
        }
        return dest;
    }

    protected abstract int pos(byte var1);
}

