/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.transform.StaxUnmarshallerContext$MetadataExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class StaxUnmarshallerContext {
    private XMLEvent currentEvent;
    private final XMLEventReader eventReader;
    public final Stack<String> stack = new Stack();
    private String stackString = "";
    private Map<String, String> metadata = new HashMap<String, String>();
    private List<StaxUnmarshallerContext$MetadataExpression> metadataExpressions = new ArrayList<StaxUnmarshallerContext$MetadataExpression>();
    private Iterator<?> attributeIterator;
    private final Map<String, String> headers;

    public StaxUnmarshallerContext(XMLEventReader eventReader) {
        this(eventReader, null);
    }

    public StaxUnmarshallerContext(XMLEventReader eventReader, Map<String, String> headers) {
        this.eventReader = eventReader;
        this.headers = headers;
    }

    public String getHeader(String header) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(header);
    }

    public String readText() {
        XMLEvent event;
        if (this.currentEvent.isAttribute()) {
            Attribute attribute = (Attribute)this.currentEvent;
            return attribute.getValue();
        }
        StringBuilder sb2 = new StringBuilder();
        while ((event = this.eventReader.peek()).getEventType() == 4) {
            this.eventReader.nextEvent();
            sb2.append(event.asCharacters().getData());
        }
        if (event.getEventType() == 2) {
            return sb2.toString();
        }
        throw new RuntimeException("Encountered unexpected event: " + event.toString());
    }

    public int getCurrentDepth() {
        return this.stack.size();
    }

    public boolean testExpression(String expression) {
        if (expression.equals(".")) {
            return true;
        }
        return this.stackString.endsWith(expression);
    }

    public boolean testExpression(String expression, int startingStackDepth) {
        if (expression.equals(".")) {
            return true;
        }
        int index = -1;
        while ((index = expression.indexOf("/", index + 1)) > -1) {
            if (expression.charAt(index + 1) == '@') continue;
            ++startingStackDepth;
        }
        return startingStackDepth == this.getCurrentDepth() && this.stackString.endsWith("/" + expression);
    }

    public boolean isStartOfDocument() {
        return this.eventReader.peek().isStartDocument();
    }

    public XMLEvent nextEvent() {
        XMLEvent nextEvent;
        this.currentEvent = this.attributeIterator != null && this.attributeIterator.hasNext() ? (XMLEvent)this.attributeIterator.next() : this.eventReader.nextEvent();
        if (this.currentEvent.isStartElement()) {
            this.attributeIterator = this.currentEvent.asStartElement().getAttributes();
        }
        this.updateContext(this.currentEvent);
        if (this.eventReader.hasNext() && (nextEvent = this.eventReader.peek()) != null && nextEvent.isCharacters()) {
            for (StaxUnmarshallerContext$MetadataExpression metadataExpression : this.metadataExpressions) {
                if (!this.testExpression(metadataExpression.expression, metadataExpression.targetDepth)) continue;
                this.metadata.put(metadataExpression.key, nextEvent.asCharacters().getData());
            }
        }
        return this.currentEvent;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void registerMetadataExpression(String expression, int targetDepth, String storageKey) {
        this.metadataExpressions.add(new StaxUnmarshallerContext$MetadataExpression(expression, targetDepth, storageKey));
    }

    private void updateContext(XMLEvent event) {
        if (event == null) {
            return;
        }
        if (event.isEndElement()) {
            this.stack.pop();
            this.stackString = "";
            for (String s2 : this.stack) {
                this.stackString = this.stackString + "/" + s2;
            }
        } else if (event.isStartElement()) {
            this.stack.push(event.asStartElement().getName().getLocalPart());
            this.stackString = this.stackString + "/" + event.asStartElement().getName().getLocalPart();
        } else if (event.isAttribute()) {
            Attribute attribute = (Attribute)event;
            this.stackString = "";
            for (String s3 : this.stack) {
                this.stackString = this.stackString + "/" + s3;
            }
            this.stackString = this.stackString + "/@" + attribute.getName().getLocalPart();
        }
    }
}

