/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonServiceException$ErrorType;
import com.amazonaws.transform.AbstractErrorUnmarshaller;
import com.amazonaws.util.XpathUtils;
import javax.xml.xpath.XPath;
import org.w3c.dom.Node;

public class StandardErrorUnmarshaller
extends AbstractErrorUnmarshaller<Node> {
    public StandardErrorUnmarshaller() {
    }

    protected StandardErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass) {
        super(exceptionClass);
    }

    @Override
    public AmazonServiceException unmarshall(Node in2) {
        XPath xpath = XpathUtils.xpath();
        String errorCode = this.parseErrorCode(in2, xpath);
        String errorType = XpathUtils.asString("ErrorResponse/Error/Type", in2, xpath);
        String requestId = XpathUtils.asString("ErrorResponse/RequestId", in2, xpath);
        String message = XpathUtils.asString("ErrorResponse/Error/Message", in2, xpath);
        AmazonServiceException ase = this.newException(message);
        ase.setErrorCode(errorCode);
        ase.setRequestId(requestId);
        if (errorType == null) {
            ase.setErrorType(AmazonServiceException$ErrorType.Unknown);
        } else if (errorType.equalsIgnoreCase("Receiver")) {
            ase.setErrorType(AmazonServiceException$ErrorType.Service);
        } else if (errorType.equalsIgnoreCase("Sender")) {
            ase.setErrorType(AmazonServiceException$ErrorType.Client);
        }
        return ase;
    }

    public String parseErrorCode(Node in2) {
        return XpathUtils.asString("ErrorResponse/Error/Code", in2);
    }

    public String parseErrorCode(Node in2, XPath xpath) {
        return XpathUtils.asString("ErrorResponse/Error/Code", in2, xpath);
    }

    public String getErrorPropertyPath(String property) {
        return "ErrorResponse/Error/" + property;
    }
}

