/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.event.DeliveryMode;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.SDKProgressPublisher;
import com.amazonaws.services.s3.transfer.PersistableTransfer;
import com.amazonaws.services.s3.transfer.internal.S3ProgressListener;
import com.amazonaws.services.s3.transfer.internal.S3ProgressPublisher$1;
import java.util.concurrent.Future;
import org.apache.commons.logging.LogFactory;

public class S3ProgressPublisher
extends SDKProgressPublisher {
    public static Future<?> publishTransferPersistable(ProgressListener listener, PersistableTransfer persistableTransfer) {
        if (persistableTransfer == null || !(listener instanceof S3ProgressListener)) {
            return null;
        }
        S3ProgressListener s3listener = (S3ProgressListener)listener;
        return S3ProgressPublisher.deliverEvent(s3listener, persistableTransfer);
    }

    private static Future<?> deliverEvent(S3ProgressListener listener, PersistableTransfer persistableTransfer) {
        DeliveryMode mode;
        if (listener instanceof DeliveryMode && (mode = (DeliveryMode)((Object)listener)).isSyncCallSafe()) {
            return S3ProgressPublisher.quietlyCallListener(listener, persistableTransfer);
        }
        return S3ProgressPublisher.setLatestFutureTask(S3ProgressPublisher.getExecutorService().submit(new S3ProgressPublisher$1(listener, persistableTransfer)));
    }

    private static Future<?> quietlyCallListener(S3ProgressListener listener, PersistableTransfer persistableTransfer) {
        try {
            listener.onPersistableTransfer(persistableTransfer);
        }
        catch (Throwable t2) {
            LogFactory.getLog(S3ProgressPublisher.class).debug("Failure from the event listener", t2);
        }
        return null;
    }
}

