/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.s3.model.transform.AbstractHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser;
import org.xml.sax.Attributes;

public class XmlResponsesSaxParser$ListVersionsHandler
extends AbstractHandler {
    private final VersionListing versionListing = new VersionListing();
    private S3VersionSummary currentVersionSummary;
    private Owner currentOwner;

    public VersionListing getListing() {
        return this.versionListing;
    }

    @Override
    protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        if (this.in("ListVersionsResult")) {
            if (name.equals("Version")) {
                this.currentVersionSummary = new S3VersionSummary();
                this.currentVersionSummary.setBucketName(this.versionListing.getBucketName());
            } else if (name.equals("DeleteMarker")) {
                this.currentVersionSummary = new S3VersionSummary();
                this.currentVersionSummary.setBucketName(this.versionListing.getBucketName());
                this.currentVersionSummary.setIsDeleteMarker(true);
            }
        } else if ((this.in("ListVersionsResult", "Version") || this.in("ListVersionsResult", "DeleteMarker")) && name.equals("Owner")) {
            this.currentOwner = new Owner();
        }
    }

    @Override
    protected void doEndElement(String uri, String name, String qName) {
        if (this.in("ListVersionsResult")) {
            if (name.equals("Name")) {
                this.versionListing.setBucketName(this.getText());
            } else if (name.equals("Prefix")) {
                this.versionListing.setPrefix(XmlResponsesSaxParser.access$100(this.getText()));
            } else if (name.equals("KeyMarker")) {
                this.versionListing.setKeyMarker(XmlResponsesSaxParser.access$100(this.getText()));
            } else if (name.equals("VersionIdMarker")) {
                this.versionListing.setVersionIdMarker(XmlResponsesSaxParser.access$100(this.getText()));
            } else if (name.equals("MaxKeys")) {
                this.versionListing.setMaxKeys(Integer.parseInt(this.getText()));
            } else if (name.equals("Delimiter")) {
                this.versionListing.setDelimiter(XmlResponsesSaxParser.access$100(this.getText()));
            } else if (name.equals("EncodingType")) {
                this.versionListing.setEncodingType(XmlResponsesSaxParser.access$100(this.getText()));
            } else if (name.equals("NextKeyMarker")) {
                this.versionListing.setNextKeyMarker(this.getText());
            } else if (name.equals("NextVersionIdMarker")) {
                this.versionListing.setNextVersionIdMarker(this.getText());
            } else if (name.equals("IsTruncated")) {
                this.versionListing.setTruncated("true".equals(this.getText()));
            } else if (name.equals("Version") || name.equals("DeleteMarker")) {
                this.versionListing.getVersionSummaries().add(this.currentVersionSummary);
                this.currentVersionSummary = null;
            }
        } else if (this.in("ListVersionsResult", "CommonPrefixes")) {
            if (name.equals("Prefix")) {
                this.versionListing.getCommonPrefixes().add(XmlResponsesSaxParser.access$100(this.getText()));
            }
        } else if (this.in("ListVersionsResult", "Version") || this.in("ListVersionsResult", "DeleteMarker")) {
            if (name.equals("Key")) {
                this.currentVersionSummary.setKey(this.getText());
            } else if (name.equals("VersionId")) {
                this.currentVersionSummary.setVersionId(this.getText());
            } else if (name.equals("IsLatest")) {
                this.currentVersionSummary.setIsLatest("true".equals(this.getText()));
            } else if (name.equals("LastModified")) {
                this.currentVersionSummary.setLastModified(ServiceUtils.parseIso8601Date(this.getText()));
            } else if (name.equals("ETag")) {
                this.currentVersionSummary.setETag(ServiceUtils.removeQuotes(this.getText()));
            } else if (name.equals("Size")) {
                this.currentVersionSummary.setSize(Long.parseLong(this.getText()));
            } else if (name.equals("Owner")) {
                this.currentVersionSummary.setOwner(this.currentOwner);
                this.currentOwner = null;
            } else if (name.equals("StorageClass")) {
                this.currentVersionSummary.setStorageClass(this.getText());
            }
        } else if (this.in("ListVersionsResult", "Version", "Owner") || this.in("ListVersionsResult", "DeleteMarker", "Owner")) {
            if (name.equals("ID")) {
                this.currentOwner.setId(this.getText());
            } else if (name.equals("DisplayName")) {
                this.currentOwner.setDisplayName(this.getText());
            }
        }
    }
}

