/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.transform.AbstractHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser;
import org.xml.sax.Attributes;

public class XmlResponsesSaxParser$ListMultipartUploadsHandler
extends AbstractHandler {
    private final MultipartUploadListing result = new MultipartUploadListing();
    private MultipartUpload currentMultipartUpload;
    private Owner currentOwner;

    public MultipartUploadListing getListMultipartUploadsResult() {
        return this.result;
    }

    @Override
    protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        if (this.in("ListMultipartUploadsResult")) {
            if (name.equals("Upload")) {
                this.currentMultipartUpload = new MultipartUpload();
            }
        } else if (this.in("ListMultipartUploadsResult", "Upload") && (name.equals("Owner") || name.equals("Initiator"))) {
            this.currentOwner = new Owner();
        }
    }

    @Override
    protected void doEndElement(String uri, String name, String qName) {
        if (this.in("ListMultipartUploadsResult")) {
            if (name.equals("Bucket")) {
                this.result.setBucketName(this.getText());
            } else if (name.equals("KeyMarker")) {
                this.result.setKeyMarker(XmlResponsesSaxParser.access$100(this.getText()));
            } else if (name.equals("Delimiter")) {
                this.result.setDelimiter(XmlResponsesSaxParser.access$100(this.getText()));
            } else if (name.equals("Prefix")) {
                this.result.setPrefix(XmlResponsesSaxParser.access$100(this.getText()));
            } else if (name.equals("UploadIdMarker")) {
                this.result.setUploadIdMarker(XmlResponsesSaxParser.access$100(this.getText()));
            } else if (name.equals("NextKeyMarker")) {
                this.result.setNextKeyMarker(XmlResponsesSaxParser.access$100(this.getText()));
            } else if (name.equals("NextUploadIdMarker")) {
                this.result.setNextUploadIdMarker(XmlResponsesSaxParser.access$100(this.getText()));
            } else if (name.equals("MaxUploads")) {
                this.result.setMaxUploads(Integer.parseInt(this.getText()));
            } else if (name.equals("EncodingType")) {
                this.result.setEncodingType(XmlResponsesSaxParser.access$100(this.getText()));
            } else if (name.equals("IsTruncated")) {
                this.result.setTruncated(Boolean.parseBoolean(this.getText()));
            } else if (name.equals("Upload")) {
                this.result.getMultipartUploads().add(this.currentMultipartUpload);
                this.currentMultipartUpload = null;
            }
        } else if (this.in("ListMultipartUploadsResult", "CommonPrefixes")) {
            if (name.equals("Prefix")) {
                this.result.getCommonPrefixes().add(this.getText());
            }
        } else if (this.in("ListMultipartUploadsResult", "Upload")) {
            if (name.equals("Key")) {
                this.currentMultipartUpload.setKey(this.getText());
            } else if (name.equals("UploadId")) {
                this.currentMultipartUpload.setUploadId(this.getText());
            } else if (name.equals("Owner")) {
                this.currentMultipartUpload.setOwner(this.currentOwner);
                this.currentOwner = null;
            } else if (name.equals("Initiator")) {
                this.currentMultipartUpload.setInitiator(this.currentOwner);
                this.currentOwner = null;
            } else if (name.equals("StorageClass")) {
                this.currentMultipartUpload.setStorageClass(this.getText());
            } else if (name.equals("Initiated")) {
                this.currentMultipartUpload.setInitiated(ServiceUtils.parseIso8601Date(this.getText()));
            }
        } else if (this.in("ListMultipartUploadsResult", "Upload", "Owner") || this.in("ListMultipartUploadsResult", "Upload", "Initiator")) {
            if (name.equals("ID")) {
                this.currentOwner.setId(XmlResponsesSaxParser.access$100(this.getText()));
            } else if (name.equals("DisplayName")) {
                this.currentOwner.setDisplayName(XmlResponsesSaxParser.access$100(this.getText()));
            }
        }
    }
}

