/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.transform.AbstractHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser;
import java.util.Locale;
import org.xml.sax.Attributes;

public class XmlResponsesSaxParser$ListBucketHandler
extends AbstractHandler {
    private final ObjectListing objectListing = new ObjectListing();
    private S3ObjectSummary currentObject = null;
    private Owner currentOwner = null;
    private String lastKey = null;

    public ObjectListing getObjectListing() {
        return this.objectListing;
    }

    @Override
    protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        if (this.in("ListBucketResult")) {
            if (name.equals("Contents")) {
                this.currentObject = new S3ObjectSummary();
                this.currentObject.setBucketName(this.objectListing.getBucketName());
            }
        } else if (this.in("ListBucketResult", "Contents") && name.equals("Owner")) {
            this.currentOwner = new Owner();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doEndElement(String uri, String name, String qName) {
        if (this.atTopLevel()) {
            if (!name.equals("ListBucketResult") || !this.objectListing.isTruncated() || this.objectListing.getNextMarker() != null) return;
            String nextMarker = null;
            if (!this.objectListing.getObjectSummaries().isEmpty()) {
                nextMarker = this.objectListing.getObjectSummaries().get(this.objectListing.getObjectSummaries().size() - 1).getKey();
            } else if (!this.objectListing.getCommonPrefixes().isEmpty()) {
                nextMarker = this.objectListing.getCommonPrefixes().get(this.objectListing.getCommonPrefixes().size() - 1);
            } else {
                XmlResponsesSaxParser.access$000().error("S3 response indicates truncated results, but contains no object summaries or common prefixes.");
            }
            this.objectListing.setNextMarker(nextMarker);
            return;
        } else if (this.in("ListBucketResult")) {
            if (name.equals("Name")) {
                this.objectListing.setBucketName(this.getText());
                if (!XmlResponsesSaxParser.access$000().isDebugEnabled()) return;
                XmlResponsesSaxParser.access$000().debug("Examining listing for bucket: " + this.objectListing.getBucketName());
                return;
            } else if (name.equals("Prefix")) {
                this.objectListing.setPrefix(XmlResponsesSaxParser.access$100(this.getText()));
                return;
            } else if (name.equals("Marker")) {
                this.objectListing.setMarker(XmlResponsesSaxParser.access$100(this.getText()));
                return;
            } else if (name.equals("NextMarker")) {
                this.objectListing.setNextMarker(this.getText());
                return;
            } else if (name.equals("MaxKeys")) {
                this.objectListing.setMaxKeys(XmlResponsesSaxParser.access$200(this.getText()));
                return;
            } else if (name.equals("Delimiter")) {
                this.objectListing.setDelimiter(XmlResponsesSaxParser.access$100(this.getText()));
                return;
            } else if (name.equals("EncodingType")) {
                this.objectListing.setEncodingType(XmlResponsesSaxParser.access$100(this.getText()));
                return;
            } else if (name.equals("IsTruncated")) {
                String isTruncatedStr = this.getText().toLowerCase(Locale.getDefault());
                if (isTruncatedStr.startsWith("false")) {
                    this.objectListing.setTruncated(false);
                    return;
                } else {
                    if (!isTruncatedStr.startsWith("true")) throw new IllegalStateException("Invalid value for IsTruncated field: " + isTruncatedStr);
                    this.objectListing.setTruncated(true);
                }
                return;
            } else {
                if (!name.equals("Contents")) return;
                this.objectListing.getObjectSummaries().add(this.currentObject);
                this.currentObject = null;
            }
            return;
        } else if (this.in("ListBucketResult", "Contents")) {
            if (name.equals("Key")) {
                this.lastKey = this.getText();
                this.currentObject.setKey(this.lastKey);
                return;
            } else if (name.equals("LastModified")) {
                this.currentObject.setLastModified(ServiceUtils.parseIso8601Date(this.getText()));
                return;
            } else if (name.equals("ETag")) {
                this.currentObject.setETag(ServiceUtils.removeQuotes(this.getText()));
                return;
            } else if (name.equals("Size")) {
                this.currentObject.setSize(XmlResponsesSaxParser.access$300(this.getText()));
                return;
            } else if (name.equals("StorageClass")) {
                this.currentObject.setStorageClass(this.getText());
                return;
            } else {
                if (!name.equals("Owner")) return;
                this.currentObject.setOwner(this.currentOwner);
                this.currentOwner = null;
            }
            return;
        } else if (this.in("ListBucketResult", "Contents", "Owner")) {
            if (name.equals("ID")) {
                this.currentOwner.setId(this.getText());
                return;
            } else {
                if (!name.equals("DisplayName")) return;
                this.currentOwner.setDisplayName(this.getText());
            }
            return;
        } else {
            if (!this.in("ListBucketResult", "CommonPrefixes") || !name.equals("Prefix")) return;
            this.objectListing.getCommonPrefixes().add(this.getText());
        }
    }
}

