/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.internal.ObjectExpirationResult;
import com.amazonaws.services.s3.internal.ServerSideEncryptionResult;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.transform.AbstractSSEHandler;
import java.util.Date;
import org.xml.sax.Attributes;

public class XmlResponsesSaxParser$CopyObjectResultHandler
extends AbstractSSEHandler
implements ObjectExpirationResult {
    private final CopyObjectResult result = new CopyObjectResult();
    private String errorCode = null;
    private String errorMessage = null;
    private String errorRequestId = null;
    private String errorHostId = null;
    private boolean receivedErrorResponse = false;

    @Override
    protected ServerSideEncryptionResult sseResult() {
        return this.result;
    }

    public Date getLastModified() {
        return this.result.getLastModifiedDate();
    }

    public String getVersionId() {
        return this.result.getVersionId();
    }

    public void setVersionId(String versionId) {
        this.result.setVersionId(versionId);
    }

    @Override
    public Date getExpirationTime() {
        return this.result.getExpirationTime();
    }

    @Override
    public void setExpirationTime(Date expirationTime) {
        this.result.setExpirationTime(expirationTime);
    }

    @Override
    public String getExpirationTimeRuleId() {
        return this.result.getExpirationTimeRuleId();
    }

    @Override
    public void setExpirationTimeRuleId(String expirationTimeRuleId) {
        this.result.setExpirationTimeRuleId(expirationTimeRuleId);
    }

    public String getETag() {
        return this.result.getETag();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorHostId() {
        return this.errorHostId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorRequestId() {
        return this.errorRequestId;
    }

    public boolean isErrorResponse() {
        return this.receivedErrorResponse;
    }

    @Override
    protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        if (this.atTopLevel()) {
            if (name.equals("CopyObjectResult") || name.equals("CopyPartResult")) {
                this.receivedErrorResponse = false;
            } else if (name.equals("Error")) {
                this.receivedErrorResponse = true;
            }
        }
    }

    @Override
    protected void doEndElement(String uri, String name, String qName) {
        if (this.in("CopyObjectResult") || this.in("CopyPartResult")) {
            if (name.equals("LastModified")) {
                this.result.setLastModifiedDate(ServiceUtils.parseIso8601Date(this.getText()));
            } else if (name.equals("ETag")) {
                this.result.setETag(ServiceUtils.removeQuotes(this.getText()));
            }
        } else if (this.in("Error")) {
            if (name.equals("Code")) {
                this.errorCode = this.getText();
            } else if (name.equals("Message")) {
                this.errorMessage = this.getText();
            } else if (name.equals("RequestId")) {
                this.errorRequestId = this.getText();
            } else if (name.equals("HostId")) {
                this.errorHostId = this.getText();
            }
        }
    }
}

