/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.internal.ObjectExpirationResult;
import com.amazonaws.services.s3.internal.ServerSideEncryptionResult;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.transform.AbstractSSEHandler;
import java.util.Date;
import org.xml.sax.Attributes;

public class XmlResponsesSaxParser$CompleteMultipartUploadHandler
extends AbstractSSEHandler
implements ObjectExpirationResult {
    private CompleteMultipartUploadResult result;
    private AmazonS3Exception ase;
    private String hostId;
    private String requestId;
    private String errorCode;

    @Override
    protected ServerSideEncryptionResult sseResult() {
        return this.result;
    }

    @Override
    public Date getExpirationTime() {
        return this.result == null ? null : this.result.getExpirationTime();
    }

    @Override
    public void setExpirationTime(Date expirationTime) {
        if (this.result != null) {
            this.result.setExpirationTime(expirationTime);
        }
    }

    @Override
    public String getExpirationTimeRuleId() {
        return this.result == null ? null : this.result.getExpirationTimeRuleId();
    }

    @Override
    public void setExpirationTimeRuleId(String expirationTimeRuleId) {
        if (this.result != null) {
            this.result.setExpirationTimeRuleId(expirationTimeRuleId);
        }
    }

    public CompleteMultipartUploadResult getCompleteMultipartUploadResult() {
        return this.result;
    }

    public AmazonS3Exception getAmazonS3Exception() {
        return this.ase;
    }

    @Override
    protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        if (this.atTopLevel() && name.equals("CompleteMultipartUploadResult")) {
            this.result = new CompleteMultipartUploadResult();
        }
    }

    @Override
    protected void doEndElement(String uri, String name, String qName) {
        if (this.atTopLevel()) {
            if (name.equals("Error") && this.ase != null) {
                this.ase.setErrorCode(this.errorCode);
                this.ase.setRequestId(this.requestId);
                this.ase.setExtendedRequestId(this.hostId);
            }
        } else if (this.in("CompleteMultipartUploadResult")) {
            if (name.equals("Location")) {
                this.result.setLocation(this.getText());
            } else if (name.equals("Bucket")) {
                this.result.setBucketName(this.getText());
            } else if (name.equals("Key")) {
                this.result.setKey(this.getText());
            } else if (name.equals("ETag")) {
                this.result.setETag(ServiceUtils.removeQuotes(this.getText()));
            }
        } else if (this.in("Error")) {
            if (name.equals("Code")) {
                this.errorCode = this.getText();
            } else if (name.equals("Message")) {
                this.ase = new AmazonS3Exception(this.getText());
            } else if (name.equals("RequestId")) {
                this.requestId = this.getText();
            } else if (name.equals("HostId")) {
                this.hostId = this.getText();
            }
        }
    }
}

