/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.model.BucketCrossOriginConfiguration;
import com.amazonaws.services.s3.model.CORSRule;
import com.amazonaws.services.s3.model.CORSRule$AllowedMethods;
import com.amazonaws.services.s3.model.transform.AbstractHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.Attributes;

public class XmlResponsesSaxParser$BucketCrossOriginConfigurationHandler
extends AbstractHandler {
    private final BucketCrossOriginConfiguration configuration = new BucketCrossOriginConfiguration(new ArrayList<CORSRule>());
    private CORSRule currentRule;
    private List<CORSRule$AllowedMethods> allowedMethods = null;
    private List<String> allowedOrigins = null;
    private List<String> exposedHeaders = null;
    private List<String> allowedHeaders = null;

    public BucketCrossOriginConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        if (this.in("CORSConfiguration")) {
            if (name.equals("CORSRule")) {
                this.currentRule = new CORSRule();
            }
        } else if (this.in("CORSConfiguration", "CORSRule")) {
            if (name.equals("AllowedOrigin")) {
                if (this.allowedOrigins == null) {
                    this.allowedOrigins = new ArrayList<String>();
                }
            } else if (name.equals("AllowedMethod")) {
                if (this.allowedMethods == null) {
                    this.allowedMethods = new ArrayList<CORSRule$AllowedMethods>();
                }
            } else if (name.equals("ExposeHeader")) {
                if (this.exposedHeaders == null) {
                    this.exposedHeaders = new ArrayList<String>();
                }
            } else if (name.equals("AllowedHeader") && this.allowedHeaders == null) {
                this.allowedHeaders = new LinkedList<String>();
            }
        }
    }

    @Override
    protected void doEndElement(String uri, String name, String qName) {
        if (this.in("CORSConfiguration")) {
            if (name.equals("CORSRule")) {
                this.currentRule.setAllowedHeaders(this.allowedHeaders);
                this.currentRule.setAllowedMethods(this.allowedMethods);
                this.currentRule.setAllowedOrigins(this.allowedOrigins);
                this.currentRule.setExposedHeaders(this.exposedHeaders);
                this.allowedHeaders = null;
                this.allowedMethods = null;
                this.allowedOrigins = null;
                this.exposedHeaders = null;
                this.configuration.getRules().add(this.currentRule);
                this.currentRule = null;
            }
        } else if (this.in("CORSConfiguration", "CORSRule")) {
            if (name.equals("ID")) {
                this.currentRule.setId(this.getText());
            } else if (name.equals("AllowedOrigin")) {
                this.allowedOrigins.add(this.getText());
            } else if (name.equals("AllowedMethod")) {
                this.allowedMethods.add(CORSRule$AllowedMethods.fromValue(this.getText()));
            } else if (name.equals("MaxAgeSeconds")) {
                this.currentRule.setMaxAgeSeconds(Integer.parseInt(this.getText()));
            } else if (name.equals("ExposeHeader")) {
                this.exposedHeaders.add(this.getText());
            } else if (name.equals("AllowedHeader")) {
                this.allowedHeaders.add(this.getText());
            }
        }
    }
}

