/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.CanonicalGrantee;
import com.amazonaws.services.s3.model.EmailAddressGrantee;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.GroupGrantee;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.transform.AbstractHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser;
import org.xml.sax.Attributes;

public class XmlResponsesSaxParser$AccessControlListHandler
extends AbstractHandler {
    private final AccessControlList accessControlList = new AccessControlList();
    private Grantee currentGrantee = null;
    private Permission currentPermission = null;

    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    @Override
    protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        if (this.in("AccessControlPolicy")) {
            if (name.equals("Owner")) {
                this.accessControlList.setOwner(new Owner());
            }
        } else if (this.in("AccessControlPolicy", "AccessControlList", "Grant") && name.equals("Grantee")) {
            String type = XmlResponsesSaxParser.access$400("xsi:type", attrs);
            if ("AmazonCustomerByEmail".equals(type)) {
                this.currentGrantee = new EmailAddressGrantee(null);
            } else if ("CanonicalUser".equals(type)) {
                this.currentGrantee = new CanonicalGrantee(null);
            } else if ("Group".equals(type)) {
                // empty if block
            }
        }
    }

    @Override
    protected void doEndElement(String uri, String name, String qName) {
        if (this.in("AccessControlPolicy", "Owner")) {
            if (name.equals("ID")) {
                this.accessControlList.getOwner().setId(this.getText());
            } else if (name.equals("DisplayName")) {
                this.accessControlList.getOwner().setDisplayName(this.getText());
            }
        } else if (this.in("AccessControlPolicy", "AccessControlList")) {
            if (name.equals("Grant")) {
                this.accessControlList.grantPermission(this.currentGrantee, this.currentPermission);
                this.currentGrantee = null;
                this.currentPermission = null;
            }
        } else if (this.in("AccessControlPolicy", "AccessControlList", "Grant")) {
            if (name.equals("Permission")) {
                this.currentPermission = Permission.parsePermission(this.getText());
            }
        } else if (this.in("AccessControlPolicy", "AccessControlList", "Grant", "Grantee")) {
            if (name.equals("ID")) {
                this.currentGrantee.setIdentifier(this.getText());
            } else if (name.equals("EmailAddress")) {
                this.currentGrantee.setIdentifier(this.getText());
            } else if (name.equals("URI")) {
                this.currentGrantee = GroupGrantee.parseGroupGrantee(this.getText());
            } else if (name.equals("DisplayName")) {
                ((CanonicalGrantee)this.currentGrantee).setDisplayName(this.getText());
            }
        }
    }
}

