/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.internal.MetricAware;
import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.MetricFilterInputStream;
import com.amazonaws.services.s3.metrics.S3ServiceMetric;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpRequestBase;

public class S3ObjectInputStream
extends SdkFilterInputStream {
    private final HttpRequestBase httpRequest;

    public S3ObjectInputStream(InputStream in2, HttpRequestBase httpRequest) {
        this(in2, httpRequest, S3ObjectInputStream.wrapWithByteCounting(in2));
    }

    public S3ObjectInputStream(InputStream in2, HttpRequestBase httpRequest, boolean collectMetrics) {
        super(collectMetrics ? new MetricFilterInputStream(S3ServiceMetric.S3DownloadThroughput, in2) : in2);
        this.httpRequest = httpRequest;
    }

    private static boolean wrapWithByteCounting(InputStream in2) {
        if (!AwsSdkMetrics.isMetricsEnabled()) {
            return false;
        }
        if (in2 instanceof MetricAware) {
            MetricAware aware = (MetricAware)((Object)in2);
            return !aware.isMetricActivated();
        }
        return true;
    }

    @Override
    public void abort() {
        this.getHttpRequest().abort();
        try {
            this.close();
        }
        catch (IOException e2) {
            LogFactory.getLog(this.getClass()).debug("FYI", e2);
        }
    }

    public HttpRequestBase getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public int available() {
        int estimate = super.available();
        return estimate == 0 ? 1 : estimate;
    }
}

