/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.iterable;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.iterable.S3Versions$VersionIterator;
import com.amazonaws.services.s3.model.S3VersionSummary;
import java.util.Iterator;

public class S3Versions
implements Iterable<S3VersionSummary> {
    private AmazonS3 s3;
    private String bucketName;
    private String prefix;
    private String key;
    private Integer batchSize;

    private S3Versions(AmazonS3 s3, String bucketName) {
        this.s3 = s3;
        this.bucketName = bucketName;
    }

    public static S3Versions inBucket(AmazonS3 s3, String bucketName) {
        return new S3Versions(s3, bucketName);
    }

    public static S3Versions withPrefix(AmazonS3 s3, String bucketName, String prefix) {
        S3Versions versions = new S3Versions(s3, bucketName);
        versions.prefix = prefix;
        return versions;
    }

    public static S3Versions forKey(AmazonS3 s3, String bucketName, String key) {
        S3Versions versions = new S3Versions(s3, bucketName);
        versions.key = key;
        return versions;
    }

    public S3Versions withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getKey() {
        return this.key;
    }

    public AmazonS3 getS3() {
        return this.s3;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public Iterator<S3VersionSummary> iterator() {
        return new S3Versions$VersionIterator(this, null);
    }
}

