/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.iterable;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.iterable.S3Objects$S3ObjectIterator;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.util.Iterator;

public class S3Objects
implements Iterable<S3ObjectSummary> {
    private AmazonS3 s3;
    private String prefix = null;
    private String bucketName;
    private Integer batchSize = null;

    private S3Objects(AmazonS3 s3, String bucketName) {
        this.s3 = s3;
        this.bucketName = bucketName;
    }

    public static S3Objects inBucket(AmazonS3 s3, String bucketName) {
        return new S3Objects(s3, bucketName);
    }

    public static S3Objects withPrefix(AmazonS3 s3, String bucketName, String prefix) {
        S3Objects objects = new S3Objects(s3, bucketName);
        objects.prefix = prefix;
        return objects;
    }

    public S3Objects withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public AmazonS3 getS3() {
        return this.s3;
    }

    @Override
    public Iterator<S3ObjectSummary> iterator() {
        return new S3Objects$S3ObjectIterator(this, null);
    }
}

