/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.iterable;

import com.amazonaws.services.s3.iterable.S3Objects;
import com.amazonaws.services.s3.iterable.S3Objects$1;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.util.Iterator;

class S3Objects$S3ObjectIterator
implements Iterator<S3ObjectSummary> {
    private ObjectListing currentListing = null;
    private Iterator<S3ObjectSummary> currentIterator = null;
    final /* synthetic */ S3Objects this$0;

    private S3Objects$S3ObjectIterator(S3Objects s3Objects) {
        this.this$0 = s3Objects;
    }

    @Override
    public boolean hasNext() {
        this.prepareCurrentListing();
        return this.currentIterator.hasNext();
    }

    @Override
    public S3ObjectSummary next() {
        this.prepareCurrentListing();
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void prepareCurrentListing() {
        while (this.currentListing == null || !this.currentIterator.hasNext() && this.currentListing.isTruncated()) {
            if (this.currentListing == null) {
                ListObjectsRequest req = new ListObjectsRequest();
                req.setBucketName(this.this$0.getBucketName());
                req.setPrefix(this.this$0.getPrefix());
                req.setMaxKeys(this.this$0.getBatchSize());
                this.currentListing = this.this$0.getS3().listObjects(req);
            } else {
                this.currentListing = this.this$0.getS3().listNextBatchOfObjects(this.currentListing);
            }
            this.currentIterator = this.currentListing.getObjectSummaries().iterator();
        }
    }

    /* synthetic */ S3Objects$S3ObjectIterator(S3Objects x0, S3Objects$1 x1) {
        this(x0);
    }
}

