/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.services.s3.internal.crypto.CipherLite;
import com.amazonaws.services.s3.internal.crypto.CipherLiteInputStream;
import java.io.InputStream;

public final class RenewableCipherLiteInputStream
extends CipherLiteInputStream {
    private boolean hasBeenAccessed;

    public RenewableCipherLiteInputStream(InputStream is2, CipherLite cipherLite) {
        super(is2, cipherLite);
    }

    public RenewableCipherLiteInputStream(InputStream is2, CipherLite c2, int buffsize) {
        super(is2, c2, buffsize);
    }

    public RenewableCipherLiteInputStream(InputStream is2, CipherLite c2, int buffsize, boolean multipart) {
        super(is2, c2, buffsize, multipart);
    }

    protected RenewableCipherLiteInputStream(InputStream is2) {
        super(is2);
    }

    @Override
    public boolean markSupported() {
        this.abortIfNeeded();
        return this.in.markSupported();
    }

    @Override
    public void mark(int readlimit) {
        this.abortIfNeeded();
        if (this.hasBeenAccessed) {
            throw new UnsupportedOperationException("Marking is only supported before your first call to read or skip.");
        }
        this.in.mark(readlimit);
    }

    @Override
    public void reset() {
        this.abortIfNeeded();
        this.in.reset();
        this.renewCipherLite();
        this.resetInternal();
        this.hasBeenAccessed = false;
    }

    @Override
    public int read() {
        this.hasBeenAccessed = true;
        return super.read();
    }

    @Override
    public int read(byte[] b2) {
        this.hasBeenAccessed = true;
        return super.read(b2);
    }

    @Override
    public int read(byte[] b2, int off, int len) {
        this.hasBeenAccessed = true;
        return super.read(b2, off, len);
    }

    @Override
    public long skip(long n2) {
        this.hasBeenAccessed = true;
        return super.skip(n2);
    }
}

