/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.services.s3.internal.crypto.CryptoRuntime$AesGcm;
import com.amazonaws.services.s3.internal.crypto.CryptoRuntime$RsaEcbOaepWithSHA256AndMGF1Padding;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.logging.LogFactory;

public class CryptoRuntime {
    static final String BOUNCY_CASTLE_PROVIDER = "BC";
    private static final String BC_PROVIDER_FQCN = "org.bouncycastle.jce.provider.BouncyCastleProvider";

    public static boolean isBouncyCastleAvailable() {
        return Security.getProvider(BOUNCY_CASTLE_PROVIDER) != null;
    }

    public static void enableBouncyCastle() {
        try {
            Class<?> c2 = Class.forName(BC_PROVIDER_FQCN);
            Provider provider = (Provider)c2.newInstance();
            Security.addProvider(provider);
        }
        catch (Exception e2) {
            LogFactory.getLog(CryptoRuntime.class).debug("Bouncy Castle not available", e2);
        }
    }

    static void recheck() {
        CryptoRuntime.recheckAesGcmAvailablility();
        CryptoRuntime.recheckRsaKeyWrapAvailablility();
    }

    public static boolean isAesGcmAvailable() {
        return CryptoRuntime$AesGcm.isAvailable;
    }

    public static void recheckAesGcmAvailablility() {
        CryptoRuntime$AesGcm.recheck();
    }

    static boolean isRsaKeyWrapAvailable() {
        return CryptoRuntime$RsaEcbOaepWithSHA256AndMGF1Padding.isAvailable;
    }

    private static void recheckRsaKeyWrapAvailablility() {
        CryptoRuntime$RsaEcbOaepWithSHA256AndMGF1Padding.recheck();
    }
}

