/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.internal.SdkFilterInputStream;
import java.io.InputStream;

public class ByteRangeCapturingInputStream
extends SdkFilterInputStream {
    private final long startingPosition;
    private final long endingPosition;
    private long streamPosition;
    private int blockPosition = 0;
    private final byte[] block;
    private long markedStreamPosition;
    private int markedBlockPosition;

    public ByteRangeCapturingInputStream(InputStream in2, long startingPosition, long endingPosition) {
        super(in2);
        if (startingPosition >= endingPosition) {
            throw new IllegalArgumentException("Invalid byte range specified: the starting position must be less than the ending position");
        }
        this.startingPosition = startingPosition;
        this.endingPosition = endingPosition;
        int blockSize = (int)(endingPosition - startingPosition);
        this.block = new byte[blockSize];
    }

    public byte[] getBlock() {
        return this.block;
    }

    @Override
    public int read() {
        int data = super.read();
        if (data == -1) {
            return -1;
        }
        if (this.streamPosition >= this.startingPosition && this.streamPosition <= this.endingPosition) {
            this.block[this.blockPosition++] = (byte)data;
        }
        ++this.streamPosition;
        return data;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        if (this.markSupported()) {
            this.markedStreamPosition = this.streamPosition;
            this.markedBlockPosition = this.blockPosition;
        }
    }

    @Override
    public synchronized void reset() {
        super.reset();
        if (this.markSupported()) {
            this.streamPosition = this.markedStreamPosition;
            this.blockPosition = this.markedBlockPosition;
        }
    }

    @Override
    public int read(byte[] b2, int off, int len) {
        int bytesRead = super.read(b2, off, len);
        if (bytesRead == -1) {
            return -1;
        }
        if (this.streamPosition + (long)bytesRead >= this.startingPosition && this.streamPosition <= this.endingPosition) {
            for (int i2 = 0; i2 < bytesRead; ++i2) {
                if (this.streamPosition + (long)i2 < this.startingPosition || this.streamPosition + (long)i2 >= this.endingPosition) continue;
                this.block[this.blockPosition++] = b2[off + i2];
            }
        }
        this.streamPosition += (long)bytesRead;
        return bytesRead;
    }
}

