/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.auth.RegionAwareSigner;
import com.amazonaws.auth.Signer;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3URI;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class S3ExecutionContext
extends ExecutionContext {
    private static final Log log = LogFactory.getLog(AmazonS3Client.class);
    private Signer signer;

    public S3ExecutionContext(List<RequestHandler2> requestHandler2s, boolean isMetricEnabled, AmazonWebServiceClient awsClient) {
        super(requestHandler2s, isMetricEnabled, awsClient);
    }

    @Override
    public void setSigner(Signer signer) {
        this.signer = signer;
    }

    @Override
    public Signer getSignerByURI(URI uri) {
        AmazonWebServiceClient awsClient = this.getAwsClient();
        if (awsClient != null && awsClient.getSignerRegionOverride() != null) {
            return this.signer;
        }
        try {
            if (this.signer instanceof RegionAwareSigner) {
                ((RegionAwareSigner)this.signer).setRegionName(new AmazonS3URI(uri).getRegion());
            }
        }
        catch (RuntimeException e2) {
            log.warn("Failed to parse the endpoint " + uri + ", and skip re-signing the signer region", e2);
        }
        return this.signer;
    }
}

