/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Mimetypes {
    private static final Log log = LogFactory.getLog(Mimetypes.class);
    public static final String MIMETYPE_XML = "application/xml";
    public static final String MIMETYPE_HTML = "text/html";
    public static final String MIMETYPE_OCTET_STREAM = "application/octet-stream";
    public static final String MIMETYPE_GZIP = "application/x-gzip";
    private static Mimetypes mimetypes = null;
    private HashMap<String, String> extensionToMimetypeMap = new HashMap();

    private Mimetypes() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Mimetypes getInstance() {
        if (mimetypes != null) {
            return mimetypes;
        }
        mimetypes = new Mimetypes();
        InputStream is2 = mimetypes.getClass().getResourceAsStream("/mime.types");
        if (is2 != null) {
            if (log.isDebugEnabled()) {
                log.debug("Loading mime types from file in the classpath: mime.types");
            }
            try {
                mimetypes.loadAndReplaceMimetypes(is2);
                return mimetypes;
            }
            catch (IOException e2) {
                if (!log.isErrorEnabled()) return mimetypes;
                log.error("Failed to load mime types from file in the classpath: mime.types", e2);
                return mimetypes;
            }
            finally {
                try {
                    is2.close();
                }
                catch (IOException ex2) {
                    log.debug("", ex2);
                }
            }
        }
        if (!log.isWarnEnabled()) return mimetypes;
        log.warn("Unable to find 'mime.types' file in classpath");
        return mimetypes;
    }

    public void loadAndReplaceMimetypes(InputStream is2) {
        BufferedReader br2 = new BufferedReader(new InputStreamReader(is2));
        String line = null;
        while ((line = br2.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
            StringTokenizer st2 = new StringTokenizer(line, " \t");
            if (st2.countTokens() > 1) {
                String mimetype = st2.nextToken();
                while (st2.hasMoreTokens()) {
                    String extension = st2.nextToken();
                    this.extensionToMimetypeMap.put(extension.toLowerCase(), mimetype);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Setting mime type for extension '" + extension.toLowerCase() + "' to '" + mimetype + "'");
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Ignoring mimetype with no associated file extensions: '" + line + "'");
        }
    }

    public String getMimetype(String fileName) {
        int lastPeriodIndex = fileName.lastIndexOf(".");
        if (lastPeriodIndex > 0 && lastPeriodIndex + 1 < fileName.length()) {
            String ext = fileName.substring(lastPeriodIndex + 1).toLowerCase();
            if (this.extensionToMimetypeMap.keySet().contains(ext)) {
                String mimetype = this.extensionToMimetypeMap.get(ext);
                if (log.isDebugEnabled()) {
                    log.debug("Recognised extension '" + ext + "', mimetype is: '" + mimetype + "'");
                }
                return mimetype;
            }
            if (log.isDebugEnabled()) {
                log.debug("Extension '" + ext + "' is unrecognized in mime type listing" + ", using default mime type: '" + MIMETYPE_OCTET_STREAM + "'");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("File name has no extension, mime type cannot be recognised for: " + fileName);
        }
        return MIMETYPE_OCTET_STREAM;
    }

    public String getMimetype(File file) {
        return this.getMimetype(file.getName());
    }
}

