/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.internal.SdkFilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5DigestCalculatingInputStream
extends SdkFilterInputStream {
    private MessageDigest digest = this.newMD5();
    private MessageDigest digestLastMarked;

    public MD5DigestCalculatingInputStream(InputStream in2) {
        super(in2);
    }

    private MessageDigest newMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e2) {
            throw new IllegalStateException("unexpected", e2);
        }
    }

    private MessageDigest cloneFrom(MessageDigest from) {
        try {
            return (MessageDigest)from.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new IllegalStateException("unexpected", e2);
        }
    }

    public byte[] getMd5Digest() {
        return this.digest.digest();
    }

    @Override
    public void mark(int readlimit) {
        if (this.markSupported()) {
            super.mark(readlimit);
            this.digestLastMarked = this.cloneFrom(this.digest);
        }
    }

    @Override
    public void reset() {
        if (!this.markSupported()) {
            throw new IOException("mark/reset not supported");
        }
        super.reset();
        this.digest = this.digestLastMarked == null ? this.newMD5() : this.cloneFrom(this.digestLastMarked);
    }

    @Override
    public int read() {
        int ch2 = super.read();
        if (ch2 != -1) {
            this.digest.update((byte)ch2);
        }
        return ch2;
    }

    @Override
    public int read(byte[] b2, int off, int len) {
        int result = super.read(b2, off, len);
        if (result != -1) {
            this.digest.update(b2, off, result);
        }
        return result;
    }
}

