/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkDigestInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;

public class DigestValidationInputStream
extends SdkDigestInputStream {
    private byte[] expectedHash;
    private boolean digestValidated = false;

    public DigestValidationInputStream(InputStream in2, MessageDigest digest, byte[] serverSideHash) {
        super(in2, digest);
        this.expectedHash = serverSideHash;
    }

    @Override
    public int read() {
        int ch2 = super.read();
        if (ch2 == -1) {
            this.validateMD5Digest();
        }
        return ch2;
    }

    @Override
    public int read(byte[] b2, int off, int len) {
        int result = super.read(b2, off, len);
        if (result == -1) {
            this.validateMD5Digest();
        }
        return result;
    }

    public byte[] getMD5Checksum() {
        return this.digest.digest();
    }

    private void validateMD5Digest() {
        if (this.expectedHash != null && !this.digestValidated) {
            this.digestValidated = true;
            if (!Arrays.equals(this.digest.digest(), this.expectedHash)) {
                throw new AmazonClientException("Unable to verify integrity of data download.  Client calculated content hash didn't match hash calculated by Amazon S3.  The data may be corrupt.");
            }
        }
    }
}

