/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.ResetException;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWS4Signer$HeaderSigningResult;
import com.amazonaws.auth.AwsChunkedEncodingInputStream;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.util.BinaryUtils;
import java.io.IOException;
import java.io.InputStream;

public class AWSS3V4Signer
extends AWS4Signer {
    private static final String CONTENT_SHA_256 = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";

    public AWSS3V4Signer() {
        super(false);
    }

    @Override
    public void processRequestPayload(Request<?> request, AWS4Signer$HeaderSigningResult headerSigningResult) {
        if (AWSS3V4Signer.useChunkEncoding(request)) {
            InputStream payloadStream = request.getContent();
            String dateTime = headerSigningResult.getDateTime();
            String keyPath = headerSigningResult.getScope();
            byte[] kSigning = headerSigningResult.getKSigning();
            String signature = BinaryUtils.toHex(headerSigningResult.getSignature());
            AwsChunkedEncodingInputStream chunkEncodededStream = new AwsChunkedEncodingInputStream(payloadStream, kSigning, dateTime, keyPath, signature, this);
            request.setContent(chunkEncodededStream);
        }
    }

    @Override
    public String calculateContentHashPresign(Request<?> request) {
        return "UNSIGNED-PAYLOAD";
    }

    @Override
    public String calculateContentHash(Request<?> request) {
        request.addHeader("x-amz-content-sha256", "required");
        if (AWSS3V4Signer.useChunkEncoding(request)) {
            long originalContentLength;
            String contentLength = request.getHeaders().get("Content-Length");
            if (contentLength != null) {
                originalContentLength = Long.parseLong(contentLength);
            } else {
                try {
                    originalContentLength = AWSS3V4Signer.getContentLength(request);
                }
                catch (IOException e2) {
                    throw new AmazonClientException("Cannot get the content-length of the request content.", e2);
                }
            }
            request.addHeader("x-amz-decoded-content-length", Long.toString(originalContentLength));
            request.addHeader("Content-Length", Long.toString(AwsChunkedEncodingInputStream.calculateStreamContentLength(originalContentLength)));
            return CONTENT_SHA_256;
        }
        return super.calculateContentHash(request);
    }

    private static boolean useChunkEncoding(Request<?> request) {
        boolean chunkedEncodingEnabled = false;
        if (request.getOriginalRequest() instanceof PutObjectRequest || request.getOriginalRequest() instanceof UploadPartRequest) {
            chunkedEncodingEnabled = true;
        }
        return chunkedEncodingEnabled;
    }

    static long getContentLength(Request<?> request) {
        int read;
        InputStream content = request.getContent();
        if (!content.markSupported()) {
            throw new IllegalStateException("Bug: request input stream must have been made mark-and-resettable at this point");
        }
        AmazonWebServiceRequest awsreq = request.getOriginalRequest();
        int readLimit = awsreq.getReadLimit();
        long contentLength = 0L;
        byte[] tmp = new byte[4096];
        content.mark(readLimit);
        while ((read = content.read(tmp)) != -1) {
            if ((contentLength += (long)read) <= (long)readLimit) continue;
            throw new ResetException("Content length exceeded the reset buffer limit of " + readLimit);
        }
        try {
            content.reset();
        }
        catch (IOException ex2) {
            throw new ResetException("Failed to reset the input stream", ex2);
        }
        return contentLength;
    }
}

