/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry;

import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.RetryPolicy$BackoffStrategy;
import com.amazonaws.retry.RetryPolicy$RetryCondition;
import org.apache.http.annotation.Immutable;

@Immutable
public final class RetryPolicy {
    private final RetryPolicy$RetryCondition retryCondition;
    private final RetryPolicy$BackoffStrategy backoffStrategy;
    private final int maxErrorRetry;
    private final boolean honorMaxErrorRetryInClientConfig;

    public RetryPolicy(RetryPolicy$RetryCondition retryCondition, RetryPolicy$BackoffStrategy backoffStrategy, int maxErrorRetry, boolean honorMaxErrorRetryInClientConfig) {
        if (retryCondition == null) {
            retryCondition = PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION;
        }
        if (backoffStrategy == null) {
            backoffStrategy = PredefinedRetryPolicies.DEFAULT_BACKOFF_STRATEGY;
        }
        if (maxErrorRetry < 0) {
            throw new IllegalArgumentException("Please provide a non-negative value for maxErrorRetry.");
        }
        this.retryCondition = retryCondition;
        this.backoffStrategy = backoffStrategy;
        this.maxErrorRetry = maxErrorRetry;
        this.honorMaxErrorRetryInClientConfig = honorMaxErrorRetryInClientConfig;
    }

    public RetryPolicy$RetryCondition getRetryCondition() {
        return this.retryCondition;
    }

    public RetryPolicy$BackoffStrategy getBackoffStrategy() {
        return this.backoffStrategy;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    public boolean isMaxErrorRetryInClientConfigHonored() {
        return this.honorMaxErrorRetryInClientConfig;
    }
}

