/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.retry.PredefinedRetryPolicies$1;
import com.amazonaws.retry.RetryPolicy$BackoffStrategy;
import com.amazonaws.retry.RetryUtils;
import java.util.Random;

class PredefinedRetryPolicies$SDKDefaultBackoffStrategy
implements RetryPolicy$BackoffStrategy {
    private static final int SCALE_FACTOR = 300;
    private static final int THROTTLING_SCALE_FACTOR = 500;
    private static final int THROTTLING_SCALE_FACTOR_RANDOM_RANGE = 125;
    private static final int MAX_BACKOFF_IN_MILLISECONDS = 20000;
    private final Random random = new Random();

    private PredefinedRetryPolicies$SDKDefaultBackoffStrategy() {
    }

    @Override
    public final long delayBeforeNextRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retries) {
        if (retries <= 0) {
            return 0L;
        }
        int scaleFactor = exception instanceof AmazonServiceException && RetryUtils.isThrottlingException((AmazonServiceException)exception) ? 500 + this.random.nextInt(125) : 300;
        long delay = (1 << retries) * scaleFactor;
        delay = Math.min(delay, 20000L);
        return delay;
    }

    /* synthetic */ PredefinedRetryPolicies$SDKDefaultBackoffStrategy(PredefinedRetryPolicies$1 x0) {
        this();
    }
}

