/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.AmazonClientException;
import com.amazonaws.regions.Region;
import com.amazonaws.util.EC2MetadataUtils;
import com.amazonaws.util.EC2MetadataUtils$InstanceInfo;

public enum Regions {
    GovCloud("us-gov-west-1"),
    US_EAST_1("us-east-1"),
    US_WEST_1("us-west-1"),
    US_WEST_2("us-west-2"),
    EU_WEST_1("eu-west-1"),
    EU_CENTRAL_1("eu-central-1"),
    AP_SOUTHEAST_1("ap-southeast-1"),
    AP_SOUTHEAST_2("ap-southeast-2"),
    AP_NORTHEAST_1("ap-northeast-1"),
    SA_EAST_1("sa-east-1"),
    CN_NORTH_1("cn-north-1");

    public static final Regions DEFAULT_REGION;
    private final String name;

    private Regions(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Regions fromName(String regionName) {
        for (Regions region : Regions.values()) {
            if (!regionName.equals(region.getName())) continue;
            return region;
        }
        throw new IllegalArgumentException("Cannot create enum from " + regionName + " value!");
    }

    public static Region getCurrentRegion() {
        try {
            EC2MetadataUtils$InstanceInfo instanceInfo = EC2MetadataUtils.getInstanceInfo();
            if (instanceInfo == null || instanceInfo.getRegion() == null) {
                return null;
            }
            return Region.getRegion(Regions.fromName(instanceInfo.getRegion()));
        }
        catch (AmazonClientException e2) {
            return null;
        }
    }

    static {
        DEFAULT_REGION = US_WEST_2;
    }
}

