/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics;

import com.amazonaws.metrics.MetricType;
import com.amazonaws.util.AWSRequestMetrics$Field;
import com.amazonaws.util.AWSServiceMetrics;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class AwsSdkMetrics$MetricRegistry {
    private final Set<MetricType> metricTypes = new HashSet<MetricType>();
    private volatile Set<MetricType> readOnly;

    AwsSdkMetrics$MetricRegistry() {
        this.metricTypes.add(AWSRequestMetrics$Field.ClientExecuteTime);
        this.metricTypes.add(AWSRequestMetrics$Field.Exception);
        this.metricTypes.add(AWSRequestMetrics$Field.ThrottleException);
        this.metricTypes.add(AWSRequestMetrics$Field.HttpClientRetryCount);
        this.metricTypes.add(AWSRequestMetrics$Field.HttpRequestTime);
        this.metricTypes.add(AWSRequestMetrics$Field.RequestCount);
        this.metricTypes.add(AWSRequestMetrics$Field.RetryCount);
        this.metricTypes.add(AWSRequestMetrics$Field.HttpClientSendRequestTime);
        this.metricTypes.add(AWSRequestMetrics$Field.HttpClientReceiveResponseTime);
        this.metricTypes.add(AWSRequestMetrics$Field.HttpClientPoolAvailableCount);
        this.metricTypes.add(AWSRequestMetrics$Field.HttpClientPoolLeasedCount);
        this.metricTypes.add(AWSRequestMetrics$Field.HttpClientPoolPendingCount);
        this.metricTypes.add(AWSServiceMetrics.HttpClientGetConnectionTime);
        this.syncReadOnly();
    }

    private void syncReadOnly() {
        this.readOnly = Collections.unmodifiableSet(new HashSet<MetricType>(this.metricTypes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMetricType(MetricType type) {
        Set<MetricType> set = this.metricTypes;
        synchronized (set) {
            boolean added = this.metricTypes.add(type);
            if (added) {
                this.syncReadOnly();
            }
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends MetricType> boolean addMetricTypes(Collection<T> types) {
        Set<MetricType> set = this.metricTypes;
        synchronized (set) {
            boolean added = this.metricTypes.addAll(types);
            if (added) {
                this.syncReadOnly();
            }
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends MetricType> void setMetricTypes(Collection<T> types) {
        Set<MetricType> set = this.metricTypes;
        synchronized (set) {
            if (types == null || types.size() == 0) {
                if (this.metricTypes.size() == 0) {
                    return;
                }
                if (types == null) {
                    types = Collections.emptyList();
                }
            }
            this.metricTypes.clear();
            if (!this.addMetricTypes(types)) {
                this.syncReadOnly();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMetricType(MetricType type) {
        Set<MetricType> set = this.metricTypes;
        synchronized (set) {
            boolean removed = this.metricTypes.remove(type);
            if (removed) {
                this.syncReadOnly();
            }
            return removed;
        }
    }

    public Set<MetricType> predefinedMetrics() {
        return this.readOnly;
    }
}

