/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.config;

import com.amazonaws.internal.config.Builder;
import com.amazonaws.internal.config.HttpClientConfig;
import com.amazonaws.internal.config.InternalConfigJsonHelper;
import com.amazonaws.internal.config.JsonIndex;
import com.amazonaws.internal.config.SignerConfig;
import com.amazonaws.internal.config.SignerConfigJsonHelper;
import com.amazonaws.util.ClassLoaderHelper;
import com.amazonaws.util.json.Jackson;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.Immutable;

@Immutable
public class InternalConfig {
    private static final Log log = LogFactory.getLog(InternalConfig.class);
    static final String DEFAULT_CONFIG_RESOURCE = "awssdk_config_default.json";
    static final String CONFIG_OVERRIDE_RESOURCE = "awssdk_config_override.json";
    private static final String SERVICE_REGION_DELIMITOR = "/";
    private final SignerConfig defaultSignerConfig;
    private final Map<String, SignerConfig> serviceRegionSigners;
    private final Map<String, SignerConfig> regionSigners;
    private final Map<String, SignerConfig> serviceSigners;
    private final Map<String, HttpClientConfig> httpClients;
    private final String userAgentTemplate;

    InternalConfig(InternalConfigJsonHelper defaults, InternalConfigJsonHelper override) {
        SignerConfigJsonHelper scb = defaults.getDefaultSigner();
        this.defaultSignerConfig = scb == null ? null : scb.build();
        this.regionSigners = this.mergeSignerMap(defaults.getRegionSigners(), override.getRegionSigners(), "region");
        this.serviceSigners = this.mergeSignerMap(defaults.getServiceSigners(), override.getServiceSigners(), "service");
        this.serviceRegionSigners = this.mergeSignerMap(defaults.getServiceRegionSigners(), override.getServiceRegionSigners(), "service/region");
        this.httpClients = this.merge(defaults.getHttpClients(), override.getHttpClients());
        this.userAgentTemplate = override.getUserAgentTemplate() != null ? override.getUserAgentTemplate() : defaults.getUserAgentTemplate();
    }

    private Map<String, SignerConfig> mergeSignerMap(JsonIndex<SignerConfigJsonHelper, SignerConfig>[] defaults, JsonIndex<SignerConfigJsonHelper, SignerConfig>[] overrides, String theme) {
        Map<String, SignerConfig> map = this.buildSignerMap(defaults, theme);
        Map<String, SignerConfig> mapOverride = this.buildSignerMap(overrides, theme);
        map.putAll(mapOverride);
        return Collections.unmodifiableMap(map);
    }

    private <C extends Builder<T>, T> Map<String, T> merge(JsonIndex<C, T>[] defaults, JsonIndex<C, T>[] overrides) {
        Map<String, T> map = this.buildMap(defaults);
        Map<String, T> mapOverride = this.buildMap(overrides);
        map.putAll(mapOverride);
        return Collections.unmodifiableMap(map);
    }

    private <C extends Builder<T>, T> Map<String, T> buildMap(JsonIndex<C, T>[] signerIndexes) {
        HashMap<String, T> map = new HashMap<String, T>();
        if (signerIndexes != null) {
            for (JsonIndex<C, T> index : signerIndexes) {
                String region = index.getKey();
                T prev = map.put(region, index.newReadOnlyConfig());
                if (prev == null) continue;
                log.warn("Duplicate definition of signer for " + index.getKey());
            }
        }
        return map;
    }

    private Map<String, SignerConfig> buildSignerMap(JsonIndex<SignerConfigJsonHelper, SignerConfig>[] signerIndexes, String theme) {
        HashMap<String, SignerConfig> map = new HashMap<String, SignerConfig>();
        if (signerIndexes != null) {
            for (JsonIndex<SignerConfigJsonHelper, SignerConfig> index : signerIndexes) {
                String region = index.getKey();
                SignerConfig prev = map.put(region, index.newReadOnlyConfig());
                if (prev == null) continue;
                log.warn("Duplicate definition of signer for " + theme + " " + index.getKey());
            }
        }
        return map;
    }

    public SignerConfig getSignerConfig(String serviceName) {
        return this.getSignerConfig(serviceName, null);
    }

    public HttpClientConfig getHttpClientConfig(String httpClientName) {
        return this.httpClients.get(httpClientName);
    }

    public SignerConfig getSignerConfig(String serviceName, String regionName) {
        if (serviceName == null) {
            throw new IllegalArgumentException();
        }
        SignerConfig signerConfig = null;
        if (regionName != null) {
            String key = serviceName + SERVICE_REGION_DELIMITOR + regionName;
            signerConfig = this.serviceRegionSigners.get(key);
            if (signerConfig != null) {
                return signerConfig;
            }
            signerConfig = this.regionSigners.get(regionName);
            if (signerConfig != null) {
                return signerConfig;
            }
        }
        return (signerConfig = this.serviceSigners.get(serviceName)) == null ? this.defaultSignerConfig : signerConfig;
    }

    public String getUserAgentTemplate() {
        return this.userAgentTemplate;
    }

    static InternalConfigJsonHelper loadfrom(URL url) {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        InternalConfigJsonHelper target = Jackson.getObjectMapper().readValue(url, InternalConfigJsonHelper.class);
        return target;
    }

    static InternalConfig load() {
        InternalConfigJsonHelper configOverride;
        URL url = ClassLoaderHelper.getResource("/awssdk_config_default.json", InternalConfig.class);
        if (url == null) {
            url = ClassLoaderHelper.getResource(DEFAULT_CONFIG_RESOURCE, InternalConfig.class);
        }
        InternalConfigJsonHelper config = InternalConfig.loadfrom(url);
        URL overrideUrl = ClassLoaderHelper.getResource("/awssdk_config_override.json", InternalConfig.class);
        if (overrideUrl == null) {
            overrideUrl = ClassLoaderHelper.getResource(CONFIG_OVERRIDE_RESOURCE, InternalConfig.class);
        }
        if (overrideUrl == null) {
            log.debug("Configuration override awssdk_config_override.json not found.");
            configOverride = new InternalConfigJsonHelper();
        } else {
            configOverride = InternalConfig.loadfrom(overrideUrl);
        }
        return new InternalConfig(config, configOverride);
    }

    void dump() {
        StringBuilder sb2 = new StringBuilder().append("defaultSignerConfig: ").append(this.defaultSignerConfig).append("\n").append("serviceRegionSigners: ").append(this.serviceRegionSigners).append("\n").append("regionSigners: ").append(this.regionSigners).append("\n").append("serviceSigners: ").append(this.serviceSigners).append("\n").append("userAgentTemplate: ").append(this.userAgentTemplate);
        log.debug(sb2.toString());
    }
}

