/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.internal.Releasable;
import com.amazonaws.internal.ResettableInputStream;
import com.amazonaws.internal.SdkFilterInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.NotThreadSafe;

@NotThreadSafe
public class ReleasableInputStream
extends SdkFilterInputStream
implements Releasable {
    private static final Log log = LogFactory.getLog(ReleasableInputStream.class);
    private boolean closeDisabled;

    protected ReleasableInputStream(InputStream is2) {
        super(is2);
    }

    @Override
    public final void close() {
        if (!this.closeDisabled) {
            this.doRelease();
        }
    }

    @Override
    public final void release() {
        this.doRelease();
    }

    private void doRelease() {
        block3: {
            try {
                this.in.close();
            }
            catch (Exception ex2) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("FYI", ex2);
            }
        }
        if (this.in instanceof Releasable) {
            Releasable r2 = (Releasable)((Object)this.in);
            r2.release();
        }
        this.abortIfNeeded();
    }

    public final boolean isCloseDisabled() {
        return this.closeDisabled;
    }

    public final <T extends ReleasableInputStream> T disableClose() {
        this.closeDisabled = true;
        ReleasableInputStream t2 = this;
        return (T)t2;
    }

    public static ReleasableInputStream wrap(InputStream is2) {
        if (is2 instanceof ReleasableInputStream) {
            return (ReleasableInputStream)is2;
        }
        if (is2 instanceof FileInputStream) {
            return ResettableInputStream.newResettableInputStream((FileInputStream)is2);
        }
        return new ReleasableInputStream(is2);
    }
}

