/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.AmazonClientException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EC2MetadataClient {
    private static final String EC2_METADATA_SERVICE_URL = "http://169.254.169.254";
    public static final String SECURITY_CREDENTIALS_RESOURCE = "/latest/meta-data/iam/security-credentials/";
    private static final Log log = LogFactory.getLog(EC2MetadataClient.class);

    public String getDefaultCredentials() {
        String securityCredentialsList = this.readResource(SECURITY_CREDENTIALS_RESOURCE);
        String[] securityCredentials = (securityCredentialsList = securityCredentialsList.trim()).split("\n");
        if (securityCredentials.length == 0) {
            return null;
        }
        String securityCredentialsName = securityCredentials[0];
        return this.readResource(SECURITY_CREDENTIALS_RESOURCE + securityCredentialsName);
    }

    public String readResource(String resourcePath) {
        URL url = this.getEc2MetadataServiceUrlForResource(resourcePath);
        log.debug("Connecting to EC2 instance metadata service at URL: " + url.toString());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(2000);
        connection.setRequestMethod("GET");
        connection.setDoOutput(true);
        connection.connect();
        return this.readResponse(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResponse(HttpURLConnection connection) {
        if (connection.getResponseCode() == 404) {
            throw new AmazonClientException("The requested metadata is not found at " + connection.getURL());
        }
        try (InputStream inputStream = connection.getInputStream();){
            int c2;
            StringBuilder buffer = new StringBuilder();
            while ((c2 = inputStream.read()) != -1) {
                buffer.append((char)c2);
            }
            String string = buffer.toString();
            return string;
        }
    }

    private URL getEc2MetadataServiceUrlForResource(String resourcePath) {
        String endpoint = EC2_METADATA_SERVICE_URL;
        if (System.getProperty("com.amazonaws.sdk.ec2MetadataServiceEndpointOverride") != null) {
            endpoint = System.getProperty("com.amazonaws.sdk.ec2MetadataServiceEndpointOverride");
        }
        return new URL(endpoint + resourcePath);
    }
}

