/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonServiceException$ErrorType;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.util.json.JSONObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;

public class JsonErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final String X_AMZN_ERROR_TYPE = "x-amzn-ErrorType";
    private List<? extends JsonErrorUnmarshaller> unmarshallerList;

    public JsonErrorResponseHandler(List<? extends JsonErrorUnmarshaller> exceptionUnmarshallers) {
        this.unmarshallerList = exceptionUnmarshallers;
    }

    @Override
    public AmazonServiceException handle(HttpResponse response) {
        JSONObject jsonErrorMessage;
        String streamContents = this.readStreamContents(response.getContent());
        try {
            String s2 = streamContents;
            if (s2.length() == 0 || s2.trim().length() == 0) {
                s2 = "{}";
            }
            jsonErrorMessage = new JSONObject(s2);
        }
        catch (Exception e2) {
            throw new AmazonClientException("Unable to parse error response: '" + streamContents + "'", e2);
        }
        String errorTypeFromHeader = this.parseErrorTypeFromHeader(response);
        AmazonServiceException ase = this.runErrorUnmarshallers(response, jsonErrorMessage, errorTypeFromHeader);
        if (ase == null) {
            return null;
        }
        ase.setServiceName(response.getRequest().getServiceName());
        ase.setStatusCode(response.getStatusCode());
        if (response.getStatusCode() < 500) {
            ase.setErrorType(AmazonServiceException$ErrorType.Client);
        } else {
            ase.setErrorType(AmazonServiceException$ErrorType.Service);
        }
        for (Map.Entry<String, String> headerEntry : response.getHeaders().entrySet()) {
            if (!headerEntry.getKey().equalsIgnoreCase("X-Amzn-RequestId")) continue;
            ase.setRequestId(headerEntry.getValue());
        }
        return ase;
    }

    private AmazonServiceException runErrorUnmarshallers(HttpResponse errorResponse, JSONObject json, String errorTypeFromHeader) {
        for (JsonErrorUnmarshaller jsonErrorUnmarshaller : this.unmarshallerList) {
            if (!jsonErrorUnmarshaller.match(errorTypeFromHeader, json)) continue;
            AmazonServiceException ase = jsonErrorUnmarshaller.unmarshall(json);
            ase.setStatusCode(errorResponse.getStatusCode());
            return ase;
        }
        return null;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    private String readStreamContents(InputStream stream) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder sb2 = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb2.append(line);
            }
            return sb2.toString();
        }
        catch (Exception e2) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AmazonClientException("Unable to read error response: " + e2.getMessage(), e2);
        }
    }

    private String parseErrorTypeFromHeader(HttpResponse response) {
        int separator;
        String headerValue = response.getHeaders().get(X_AMZN_ERROR_TYPE);
        if (headerValue != null && (separator = headerValue.indexOf(58)) != -1) {
            headerValue = headerValue.substring(0, separator);
        }
        return headerValue;
    }
}

