/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.auth.Signer;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpRequestFactory;
import com.amazonaws.retry.internal.AuthRetryParameters;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

class AmazonHttpClient$ExecOneRequestParams {
    private Signer signer;
    private URI signerURI;
    int requestCount;
    AmazonClientException retriedException;
    HttpRequestBase apacheRequest;
    HttpResponse apacheResponse;
    URI redirectedURI;
    AuthRetryParameters authRetryParam;
    boolean leaveHttpConnectionOpen;

    private AmazonHttpClient$ExecOneRequestParams() {
    }

    boolean isRetry() {
        return this.requestCount > 1 || this.redirectedURI != null || this.authRetryParam != null;
    }

    void initPerRetry() {
        ++this.requestCount;
        this.apacheRequest = null;
        this.apacheResponse = null;
        this.leaveHttpConnectionOpen = false;
    }

    Signer newSigner(Request<?> request, ExecutionContext execContext) {
        if (this.authRetryParam != null) {
            this.signerURI = this.authRetryParam.getEndpointForRetry();
            this.signer = this.authRetryParam.getSignerForRetry();
            execContext.setSigner(this.signer);
        } else if (this.redirectedURI != null && !this.redirectedURI.equals(this.signerURI)) {
            this.signerURI = this.redirectedURI;
            this.signer = execContext.getSignerByURI(this.signerURI);
        } else if (this.signer == null) {
            this.signerURI = request.getEndpoint();
            this.signer = execContext.getSignerByURI(this.signerURI);
        }
        return this.signer;
    }

    HttpRequestBase newApacheRequest(HttpRequestFactory httpRequestFactory, Request<?> request, ClientConfiguration config, ExecutionContext execContext) {
        this.apacheRequest = httpRequestFactory.createHttpRequest(request, config, execContext);
        if (this.redirectedURI != null) {
            this.apacheRequest.setURI(this.redirectedURI);
        }
        return this.apacheRequest;
    }

    void resetBeforeHttpRequest() {
        this.retriedException = null;
        this.authRetryParam = null;
        this.redirectedURI = null;
    }

    static /* synthetic */ Signer access$100(AmazonHttpClient$ExecOneRequestParams x0) {
        return x0.signer;
    }
}

