/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.auth.profile.ProfilesConfigFileWriter$ProfilesConfigFileWriterHelper;
import com.amazonaws.auth.profile.internal.Profile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProfilesConfigFileWriter {
    private static final Log LOG = LogFactory.getLog(ProfilesConfigFileWriter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpToFile(File destination, boolean overwrite, Profile ... profiles) {
        FileWriter writer;
        if (destination.exists() && !overwrite) {
            throw new AmazonClientException("The destination file already exists. Set overwrite=true if you want to clobber the existing content and completely re-write the file.");
        }
        try {
            writer = new FileWriter(destination, false);
        }
        catch (IOException ioe) {
            throw new AmazonClientException("Unable to open the destination file.", ioe);
        }
        try {
            LinkedHashMap<String, Profile> modifications = new LinkedHashMap<String, Profile>();
            for (Profile profile : profiles) {
                modifications.put(profile.getProfileName(), profile);
            }
            ProfilesConfigFileWriter$ProfilesConfigFileWriterHelper writerHelper = new ProfilesConfigFileWriter$ProfilesConfigFileWriterHelper(writer, modifications);
            writerHelper.writeWithoutExistingContent();
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void modifyOrInsertProfiles(File destination, Profile ... profiles) {
        LinkedHashMap<String, Profile> modifications = new LinkedHashMap<String, Profile>();
        for (Profile profile : profiles) {
            modifications.put(profile.getProfileName(), profile);
        }
        ProfilesConfigFileWriter.modifyProfiles(destination, modifications);
    }

    public static void modifyOneProfile(File destination, String profileName, Profile newProfile) {
        Map<String, Profile> modifications = Collections.singletonMap(profileName, newProfile);
        ProfilesConfigFileWriter.modifyProfiles(destination, modifications);
    }

    public static void deleteProfiles(File destination, String ... profileNames) {
        LinkedHashMap<String, Profile> modifications = new LinkedHashMap<String, Profile>();
        for (String profileName : profileNames) {
            modifications.put(profileName, null);
        }
        ProfilesConfigFileWriter.modifyProfiles(destination, modifications);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void modifyProfiles(File destination, Map<String, Profile> modifications) {
        boolean inPlaceModify = destination.exists();
        File stashLocation = null;
        if (inPlaceModify) {
            boolean stashed = false;
            try {
                stashLocation = new File(destination.getParentFile(), destination.getName() + ".bak." + UUID.randomUUID().toString());
                stashed = destination.renameTo(stashLocation);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("The original credentials file is stashed to loaction (%s).", stashLocation.getAbsolutePath()));
                }
            }
            finally {
                if (!stashed) {
                    throw new AmazonClientException("Failed to stash the existing credentials file before applying the changes.");
                }
            }
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(destination);
            ProfilesConfigFileWriter$ProfilesConfigFileWriterHelper writerHelper = new ProfilesConfigFileWriter$ProfilesConfigFileWriterHelper(writer, modifications);
            if (inPlaceModify) {
                Scanner existingContent = new Scanner(stashLocation);
                writerHelper.writeWithExistingContent(existingContent);
            } else {
                writerHelper.writeWithoutExistingContent();
            }
            new ProfilesConfigFile(destination);
            if (inPlaceModify && !stashLocation.delete() && LOG.isDebugEnabled()) {
                LOG.debug(String.format("Successfully modified the credentials file. But failed to delete the stashed copy of the original file (%s).", stashLocation.getAbsolutePath()));
            }
        }
        catch (Exception e2) {
            if (inPlaceModify) {
                boolean restored = false;
                try {
                    if (!destination.delete()) {
                        LOG.debug("Unable to remove the credentials file before restoring the original one.");
                    }
                    restored = stashLocation.renameTo(destination);
                }
                finally {
                    if (!restored) {
                        throw new AmazonClientException("Unable to restore the original credentials file. File content stashed in " + stashLocation.getAbsolutePath());
                    }
                }
            }
            throw new AmazonClientException("Unable to modify the credentials file. (The original file has been restored.)", e2);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

