/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.policy.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.policy.Action;
import com.amazonaws.auth.policy.Condition;
import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.Principal;
import com.amazonaws.auth.policy.Principal$WebIdentityProviders;
import com.amazonaws.auth.policy.Resource;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.auth.policy.Statement$Effect;
import com.amazonaws.auth.policy.internal.JsonPolicyReader$NamedAction;
import com.amazonaws.util.json.Jackson;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JsonPolicyReader {
    private static final String PRINCIPAL_SCHEMA_USER = "AWS";
    private static final String PRINCIPAL_SCHEMA_SERVICE = "Service";
    private static final String PRINICIPAL_SCHEMA_FEDERATED = "Federated";

    public Policy createPolicyFromJsonString(String jsonString) {
        if (jsonString == null) {
            throw new IllegalArgumentException("JSON string cannot be null");
        }
        Policy policy = new Policy();
        LinkedList<Statement> statements = new LinkedList<Statement>();
        try {
            fH statementNodes;
            fH policyNode = Jackson.jsonNodeOf(jsonString);
            fH idNode = policyNode.a("Id");
            if (this.isNotNull(idNode)) {
                policy.setId(idNode.b());
            }
            if (this.isNotNull(statementNodes = policyNode.a("Statement"))) {
                for (fH node : statementNodes) {
                    statements.add(this.statementOf(node));
                }
            }
        }
        catch (Exception e2) {
            String message = "Unable to generate policy object fron JSON string " + e2.getMessage();
            throw new IllegalArgumentException(message, e2);
        }
        policy.setStatements(statements);
        return policy;
    }

    private Statement statementOf(fH jStatement) {
        fH principalNodes;
        fH conditionNodes;
        fH resourceNodes;
        fH actionNodes;
        fH effect = jStatement.a("Effect");
        if (!this.isNotNull(effect)) {
            return null;
        }
        Statement statement = new Statement(Statement$Effect.valueOf(effect.b()));
        fH id2 = jStatement.a("Sid");
        if (this.isNotNull(id2)) {
            statement.setId(id2.b());
        }
        if (this.isNotNull(actionNodes = jStatement.a("Action"))) {
            statement.setActions(this.actionsOf(actionNodes));
        }
        if (this.isNotNull(resourceNodes = jStatement.a("Resource"))) {
            statement.setResources(this.resourcesOf(resourceNodes));
        }
        if (this.isNotNull(conditionNodes = jStatement.a("Condition"))) {
            statement.setConditions(this.conditionsOf(conditionNodes));
        }
        if (this.isNotNull(principalNodes = jStatement.a("Principal"))) {
            statement.setPrincipals(this.principalOf(principalNodes));
        }
        return statement;
    }

    private List<Action> actionsOf(fH actionNodes) {
        LinkedList<Action> actions = new LinkedList<Action>();
        if (actionNodes.a()) {
            for (fH action : actionNodes) {
                actions.add(new JsonPolicyReader$NamedAction(action.b()));
            }
        } else {
            actions.add(new JsonPolicyReader$NamedAction(actionNodes.b()));
        }
        return actions;
    }

    private List<Resource> resourcesOf(fH resourceNodes) {
        LinkedList<Resource> resources = new LinkedList<Resource>();
        if (resourceNodes.a()) {
            for (fH resource : resourceNodes) {
                resources.add(new Resource(resource.b()));
            }
        } else {
            resources.add(new Resource(resourceNodes.b()));
        }
        return resources;
    }

    private List<Principal> principalOf(fH principalNodes) {
        LinkedList<Principal> principals = new LinkedList<Principal>();
        if (principalNodes.b().equals("*")) {
            principals.add(Principal.All);
            return principals;
        }
        Iterator<Map.Entry<String, fH>> mapOfPrincipals = principalNodes.b();
        while (mapOfPrincipals.hasNext()) {
            Map.Entry<String, fH> principal = mapOfPrincipals.next();
            String schema = principal.getKey();
            fH principalNode = principal.getValue();
            if (principalNode.a()) {
                Iterator<fH> elements = principalNode.a();
                while (elements.hasNext()) {
                    principals.add(this.createPrincipal(schema, elements.next()));
                }
                continue;
            }
            principals.add(this.createPrincipal(schema, principalNode));
        }
        return principals;
    }

    private Principal createPrincipal(String schema, fH principalNode) {
        if (schema.equalsIgnoreCase(PRINCIPAL_SCHEMA_USER)) {
            return new Principal(principalNode.b());
        }
        if (schema.equalsIgnoreCase(PRINCIPAL_SCHEMA_SERVICE)) {
            return new Principal(schema, principalNode.b());
        }
        if (schema.equalsIgnoreCase(PRINICIPAL_SCHEMA_FEDERATED)) {
            if (Principal$WebIdentityProviders.fromString(principalNode.b()) != null) {
                return new Principal(Principal$WebIdentityProviders.fromString(principalNode.b()));
            }
            return new Principal(PRINICIPAL_SCHEMA_FEDERATED, principalNode.b());
        }
        throw new AmazonClientException("Schema " + schema + " is not a valid value for the principal.");
    }

    private List<Condition> conditionsOf(fH conditionNodes) {
        LinkedList<Condition> conditionList = new LinkedList<Condition>();
        Iterator<Map.Entry<String, fH>> mapOfConditions = conditionNodes.b();
        while (mapOfConditions.hasNext()) {
            Map.Entry<String, fH> condition = mapOfConditions.next();
            this.convertConditionRecord(conditionList, condition.getKey(), condition.getValue());
        }
        return conditionList;
    }

    private void convertConditionRecord(List<Condition> conditions, String conditionType, fH conditionNode) {
        Iterator<Map.Entry<String, fH>> mapOfFields = conditionNode.b();
        while (mapOfFields.hasNext()) {
            LinkedList<String> values = new LinkedList<String>();
            Map.Entry<String, fH> field = mapOfFields.next();
            fH fieldValue = field.getValue();
            if (fieldValue.a()) {
                Iterator<fH> elements = fieldValue.a();
                while (elements.hasNext()) {
                    values.add(elements.next().b());
                }
            } else {
                values.add(fieldValue.b());
            }
            conditions.add(new Condition().withType(conditionType).withConditionKey(field.getKey()).withValues(values));
        }
    }

    private boolean isNotNull(Object object) {
        return null != object;
    }
}

