/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.policy;

import com.amazonaws.auth.policy.Principal$Services;
import com.amazonaws.auth.policy.Principal$WebIdentityProviders;

public class Principal {
    public static final Principal AllUsers = new Principal("AWS", "*");
    public static final Principal AllServices = new Principal("Service", "*");
    public static final Principal AllWebProviders = new Principal("Federated", "*");
    public static final Principal All = new Principal("*", "*");
    private final String id;
    private final String provider;

    public Principal(Principal$Services service) {
        if (service == null) {
            throw new IllegalArgumentException("Null AWS service name specified");
        }
        this.id = service.getServiceId();
        this.provider = "Service";
    }

    public Principal(String accountId) {
        this("AWS", accountId);
        if (accountId == null) {
            throw new IllegalArgumentException("Null AWS account ID specified");
        }
    }

    public Principal(String provider, String id2) {
        this(provider, id2, provider.equals("AWS"));
    }

    public Principal(String provider, String id2, boolean stripHyphen) {
        this.provider = provider;
        this.id = stripHyphen ? id2.replace("-", "") : id2;
    }

    public Principal(Principal$WebIdentityProviders webIdentityProvider) {
        if (webIdentityProvider == null) {
            throw new IllegalArgumentException("Null web identity provider specified");
        }
        this.id = webIdentityProvider.getWebIdentityProvider();
        this.provider = "Federated";
    }

    public String getProvider() {
        return this.provider;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + this.provider.hashCode();
        hashCode = 31 * hashCode + this.id.hashCode();
        return hashCode;
    }

    public boolean equals(Object principal) {
        if (this == principal) {
            return true;
        }
        if (principal == null) {
            return false;
        }
        if (!(principal instanceof Principal)) {
            return false;
        }
        Principal other = (Principal)principal;
        return this.getProvider().equals(other.getProvider()) && this.getId().equals(other.getId());
    }
}

