/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws;

import com.amazonaws.AmazonWebServiceRequest$1;
import com.amazonaws.RequestClientOptions;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.metrics.RequestMetricCollector;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.annotation.NotThreadSafe;

@NotThreadSafe
public abstract class AmazonWebServiceRequest {
    public static final AmazonWebServiceRequest NOOP = new AmazonWebServiceRequest$1();
    private ProgressListener progressListener = ProgressListener.NOOP;
    private final RequestClientOptions requestClientOptions = new RequestClientOptions();
    private RequestMetricCollector requestMetricCollector;
    private AWSCredentials credentials;
    private Map<String, String> customRequestHeaders;

    public void setRequestCredentials(AWSCredentials credentials) {
        this.credentials = credentials;
    }

    public AWSCredentials getRequestCredentials() {
        return this.credentials;
    }

    public Map<String, String> copyPrivateRequestParameters() {
        return new HashMap<String, String>();
    }

    public RequestClientOptions getRequestClientOptions() {
        return this.requestClientOptions;
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public void setRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.requestMetricCollector = requestMetricCollector;
    }

    public <T extends AmazonWebServiceRequest> T withRequestMetricCollector(RequestMetricCollector metricCollector) {
        this.setRequestMetricCollector(metricCollector);
        AmazonWebServiceRequest t2 = this;
        return (T)t2;
    }

    public void setGeneralProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener == null ? ProgressListener.NOOP : progressListener;
    }

    public ProgressListener getGeneralProgressListener() {
        return this.progressListener;
    }

    public <T extends AmazonWebServiceRequest> T withGeneralProgressListener(ProgressListener progressListener) {
        this.setGeneralProgressListener(progressListener);
        AmazonWebServiceRequest t2 = this;
        return (T)t2;
    }

    public Map<String, String> getCustomRequestHeaders() {
        if (this.customRequestHeaders == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.customRequestHeaders);
    }

    public String putCustomRequestHeader(String name, String value) {
        if (this.customRequestHeaders == null) {
            this.customRequestHeaders = new HashMap<String, String>();
        }
        return this.customRequestHeaders.put(name, value);
    }

    public final int getReadLimit() {
        return this.requestClientOptions.getReadLimit();
    }

    protected final <T extends AmazonWebServiceRequest> T copyBaseTo(T target) {
        if (this.customRequestHeaders != null) {
            for (Map.Entry<String, String> e2 : this.customRequestHeaders.entrySet()) {
                target.putCustomRequestHeader(e2.getKey(), e2.getValue());
            }
        }
        target.setRequestCredentials(this.credentials);
        target.setGeneralProgressListener(this.progressListener);
        target.setRequestMetricCollector(this.requestMetricCollector);
        this.requestClientOptions.copyTo(target.getRequestClientOptions());
        return target;
    }
}

