/*
 * Decompiled with CFR 0.152.
 */
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class Vo
extends VE {
    public static final Vo ZERO = new Vo(0);
    public static final Vo ONE = new Vo(1);
    public static final Vo TWO = new Vo(2);
    public static final Vo THREE = new Vo(3);
    public static final Vo MAX_VALUE = new Vo(Integer.MAX_VALUE);
    public static final Vo MIN_VALUE = new Vo(Integer.MIN_VALUE);
    private static final XL PARSER = XG.a().a(UZ.weeks());
    private static final long serialVersionUID = 87525275727380866L;

    public static Vo weeks(int n2) {
        switch (n2) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new Vo(n2);
    }

    public static Vo weeksBetween(Vg vg2, Vg vg3) {
        int n2 = VE.between(vg2, vg3, UF.weeks());
        return Vo.weeks(n2);
    }

    public static Vo weeksBetween(Vi vi2, Vi vi3) {
        if (vi2 instanceof UN && vi3 instanceof UN) {
            Un un2 = Uv.a(vi2.getChronology());
            int n2 = un2.weeks().getDifference(((UN)vi3).getLocalMillis(), ((UN)vi2).getLocalMillis());
            return Vo.weeks(n2);
        }
        int n3 = VE.between(vi2, vi3, ZERO);
        return Vo.weeks(n3);
    }

    public static Vo weeksIn(Vh vh2) {
        if (vh2 == null) {
            return ZERO;
        }
        int n2 = VE.between(vh2.getStart(), vh2.getEnd(), UF.weeks());
        return Vo.weeks(n2);
    }

    public static Vo standardWeeksIn(Vj vj2) {
        int n2 = VE.standardPeriodIn(vj2, 604800000L);
        return Vo.weeks(n2);
    }

    @FromString
    public static Vo parseWeeks(String string) {
        if (string == null) {
            return ZERO;
        }
        UY uY2 = PARSER.a(string);
        return Vo.weeks(uY2.getWeeks());
    }

    private Vo(int n2) {
        super(n2);
    }

    private Object readResolve() {
        return Vo.weeks(this.getValue());
    }

    @Override
    public UF getFieldType() {
        return UF.weeks();
    }

    @Override
    public UZ getPeriodType() {
        return UZ.weeks();
    }

    public UC toStandardDays() {
        return UC.days(WS.b(this.getValue(), 7));
    }

    public UH toStandardHours() {
        return UH.hours(WS.b(this.getValue(), 168));
    }

    public UT toStandardMinutes() {
        return UT.minutes(WS.b(this.getValue(), 10080));
    }

    public Vk toStandardSeconds() {
        return Vk.seconds(WS.b(this.getValue(), 604800));
    }

    public UD toStandardDuration() {
        long l2 = this.getValue();
        return new UD(l2 * 604800000L);
    }

    public int getWeeks() {
        return this.getValue();
    }

    public Vo plus(int n2) {
        if (n2 == 0) {
            return this;
        }
        return Vo.weeks(WS.a(this.getValue(), n2));
    }

    public Vo plus(Vo vo2) {
        if (vo2 == null) {
            return this;
        }
        return this.plus(vo2.getValue());
    }

    public Vo minus(int n2) {
        return this.plus(WS.a(n2));
    }

    public Vo minus(Vo vo2) {
        if (vo2 == null) {
            return this;
        }
        return this.minus(vo2.getValue());
    }

    public Vo multipliedBy(int n2) {
        return Vo.weeks(WS.b(this.getValue(), n2));
    }

    public Vo dividedBy(int n2) {
        if (n2 == 1) {
            return this;
        }
        return Vo.weeks(this.getValue() / n2);
    }

    public Vo negated() {
        return Vo.weeks(WS.a(this.getValue()));
    }

    public boolean isGreaterThan(Vo vo2) {
        if (vo2 == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > vo2.getValue();
    }

    public boolean isLessThan(Vo vo2) {
        if (vo2 == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < vo2.getValue();
    }

    @ToString
    public String toString() {
        return "P" + String.valueOf(this.getValue()) + "W";
    }
}

