/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class UR
extends VA
implements Vi,
Serializable {
    private static final long serialVersionUID = -12873158713873L;
    public static final UR MIDNIGHT = new UR(0, 0, 0, 0);
    private static final int HOUR_OF_DAY = 0;
    private static final int MINUTE_OF_HOUR = 1;
    private static final int SECOND_OF_MINUTE = 2;
    private static final int MILLIS_OF_SECOND = 3;
    private static final Set<UF> TIME_DURATION_TYPES = new HashSet<UF>();
    private final long iLocalMillis;
    private final Un iChronology;

    public static UR now() {
        return new UR();
    }

    public static UR now(Uy uy2) {
        if (uy2 == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new UR(uy2);
    }

    public static UR now(Un un2) {
        if (un2 == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new UR(un2);
    }

    @FromString
    public static UR parse(String string) {
        return UR.parse(string, XE.c());
    }

    public static UR parse(String string, Xi xi2) {
        return xi2.a(string);
    }

    public static UR fromMillisOfDay(long l2) {
        return UR.fromMillisOfDay(l2, null);
    }

    public static UR fromMillisOfDay(long l2, Un un2) {
        un2 = Uv.a(un2).withUTC();
        return new UR(l2, un2);
    }

    public static UR fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new UR(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static UR fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new UR(date.getHours(), date.getMinutes(), date.getSeconds(), ((int)(date.getTime() % 1000L) + 1000) % 1000);
    }

    public UR() {
        this(Uv.a(), (Un)Wf.getInstance());
    }

    public UR(Uy uy2) {
        this(Uv.a(), (Un)Wf.getInstance(uy2));
    }

    public UR(Un un2) {
        this(Uv.a(), un2);
    }

    public UR(long l2) {
        this(l2, (Un)Wf.getInstance());
    }

    public UR(long l2, Uy uy2) {
        this(l2, (Un)Wf.getInstance(uy2));
    }

    public UR(long l2, Un un2) {
        un2 = Uv.a(un2);
        long l3 = un2.getZone().getMillisKeepLocal(Uy.UTC, l2);
        un2 = un2.withUTC();
        this.iLocalMillis = un2.millisOfDay().get(l3);
        this.iChronology = un2;
    }

    public UR(Object object) {
        this(object, (Un)null);
    }

    public UR(Object object, Uy uy2) {
        WC wC2 = Wt.a().a(object);
        Un un2 = wC2.a(object, uy2);
        un2 = Uv.a(un2);
        this.iChronology = un2.withUTC();
        int[] nArray = wC2.a(this, object, un2, XE.c());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(0L, nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public UR(Object object, Un un2) {
        WC wC2 = Wt.a().a(object);
        un2 = wC2.a(object, un2);
        un2 = Uv.a(un2);
        this.iChronology = un2.withUTC();
        int[] nArray = wC2.a(this, object, un2, XE.c());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(0L, nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public UR(int n2, int n3) {
        this(n2, n3, 0, 0, Wf.getInstanceUTC());
    }

    public UR(int n2, int n3, int n4) {
        this(n2, n3, n4, 0, Wf.getInstanceUTC());
    }

    public UR(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, Wf.getInstanceUTC());
    }

    public UR(int n2, int n3, int n4, int n5, Un un2) {
        un2 = Uv.a(un2).withUTC();
        long l2 = un2.getDateTimeMillis(0L, n2, n3, n4, n5);
        this.iChronology = un2;
        this.iLocalMillis = l2;
    }

    private Object readResolve() {
        if (this.iChronology == null) {
            return new UR(this.iLocalMillis, (Un)Wf.getInstanceUTC());
        }
        if (!Uy.UTC.equals(this.iChronology.getZone())) {
            return new UR(this.iLocalMillis, this.iChronology.withUTC());
        }
        return this;
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    protected Us getField(int n2, Un un2) {
        switch (n2) {
            case 0: {
                return un2.hourOfDay();
            }
            case 1: {
                return un2.minuteOfHour();
            }
            case 2: {
                return un2.secondOfMinute();
            }
            case 3: {
                return un2.millisOfSecond();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + n2);
    }

    @Override
    public int getValue(int n2) {
        switch (n2) {
            case 0: {
                return this.getChronology().hourOfDay().get(this.getLocalMillis());
            }
            case 1: {
                return this.getChronology().minuteOfHour().get(this.getLocalMillis());
            }
            case 2: {
                return this.getChronology().secondOfMinute().get(this.getLocalMillis());
            }
            case 3: {
                return this.getChronology().millisOfSecond().get(this.getLocalMillis());
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + n2);
    }

    @Override
    public int get(Ut ut2) {
        if (ut2 == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(ut2)) {
            throw new IllegalArgumentException("Field '" + ut2 + "' is not supported");
        }
        return ut2.getField(this.getChronology()).get(this.getLocalMillis());
    }

    @Override
    public boolean isSupported(Ut ut2) {
        if (ut2 == null) {
            return false;
        }
        if (!this.isSupported(ut2.getDurationType())) {
            return false;
        }
        UF uF2 = ut2.getRangeDurationType();
        return this.isSupported(uF2) || uF2 == UF.days();
    }

    public boolean isSupported(UF uF2) {
        if (uF2 == null) {
            return false;
        }
        UE uE2 = uF2.getField(this.getChronology());
        if (TIME_DURATION_TYPES.contains(uF2) || uE2.getUnitMillis() < this.getChronology().days().getUnitMillis()) {
            return uE2.isSupported();
        }
        return false;
    }

    @Override
    protected long getLocalMillis() {
        return this.iLocalMillis;
    }

    @Override
    public Un getChronology() {
        return this.iChronology;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof UR) {
            UR uR2 = (UR)object;
            if (this.iChronology.equals(uR2.iChronology)) {
                return this.iLocalMillis == uR2.iLocalMillis;
            }
        }
        return super.equals(object);
    }

    @Override
    public int compareTo(Vi vi2) {
        if (this == vi2) {
            return 0;
        }
        if (vi2 instanceof UR) {
            UR uR2 = (UR)vi2;
            if (this.iChronology.equals(uR2.iChronology)) {
                return this.iLocalMillis < uR2.iLocalMillis ? -1 : (this.iLocalMillis == uR2.iLocalMillis ? 0 : 1);
            }
        }
        return super.compareTo(vi2);
    }

    UR withLocalMillis(long l2) {
        return l2 == this.getLocalMillis() ? this : new UR(l2, this.getChronology());
    }

    public UR withFields(Vi vi2) {
        if (vi2 == null) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().set(vi2, this.getLocalMillis()));
    }

    public UR withField(Ut ut2, int n2) {
        if (ut2 == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (!this.isSupported(ut2)) {
            throw new IllegalArgumentException("Field '" + ut2 + "' is not supported");
        }
        long l2 = ut2.getField(this.getChronology()).set(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UR withFieldAdded(UF uF2, int n2) {
        if (uF2 == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (!this.isSupported(uF2)) {
            throw new IllegalArgumentException("Field '" + uF2 + "' is not supported");
        }
        if (n2 == 0) {
            return this;
        }
        long l2 = uF2.getField(this.getChronology()).add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UR withPeriodAdded(Vj vj2, int n2) {
        if (vj2 == null || n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().add(vj2, this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UR plus(Vj vj2) {
        return this.withPeriodAdded(vj2, 1);
    }

    public UR plusHours(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().hours().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UR plusMinutes(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().minutes().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UR plusSeconds(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().seconds().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UR plusMillis(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().millis().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UR minus(Vj vj2) {
        return this.withPeriodAdded(vj2, -1);
    }

    public UR minusHours(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().hours().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UR minusMinutes(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().minutes().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UR minusSeconds(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().seconds().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UR minusMillis(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().millis().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public US property(Ut ut2) {
        if (ut2 == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(ut2)) {
            throw new IllegalArgumentException("Field '" + ut2 + "' is not supported");
        }
        return new US(this, ut2.getField(this.getChronology()));
    }

    public int getHourOfDay() {
        return this.getChronology().hourOfDay().get(this.getLocalMillis());
    }

    public int getMinuteOfHour() {
        return this.getChronology().minuteOfHour().get(this.getLocalMillis());
    }

    public int getSecondOfMinute() {
        return this.getChronology().secondOfMinute().get(this.getLocalMillis());
    }

    public int getMillisOfSecond() {
        return this.getChronology().millisOfSecond().get(this.getLocalMillis());
    }

    public int getMillisOfDay() {
        return this.getChronology().millisOfDay().get(this.getLocalMillis());
    }

    public UR withHourOfDay(int n2) {
        return this.withLocalMillis(this.getChronology().hourOfDay().set(this.getLocalMillis(), n2));
    }

    public UR withMinuteOfHour(int n2) {
        return this.withLocalMillis(this.getChronology().minuteOfHour().set(this.getLocalMillis(), n2));
    }

    public UR withSecondOfMinute(int n2) {
        return this.withLocalMillis(this.getChronology().secondOfMinute().set(this.getLocalMillis(), n2));
    }

    public UR withMillisOfSecond(int n2) {
        return this.withLocalMillis(this.getChronology().millisOfSecond().set(this.getLocalMillis(), n2));
    }

    public UR withMillisOfDay(int n2) {
        return this.withLocalMillis(this.getChronology().millisOfDay().set(this.getLocalMillis(), n2));
    }

    public US hourOfDay() {
        return new US(this, this.getChronology().hourOfDay());
    }

    public US minuteOfHour() {
        return new US(this, this.getChronology().minuteOfHour());
    }

    public US secondOfMinute() {
        return new US(this, this.getChronology().secondOfMinute());
    }

    public US millisOfSecond() {
        return new US(this, this.getChronology().millisOfSecond());
    }

    public US millisOfDay() {
        return new US(this, this.getChronology().millisOfDay());
    }

    public Uq toDateTimeToday() {
        return this.toDateTimeToday(null);
    }

    public Uq toDateTimeToday(Uy uy2) {
        Un un2 = this.getChronology().withZone(uy2);
        long l2 = Uv.a();
        long l3 = un2.set(this, l2);
        return new Uq(l3, un2);
    }

    @ToString
    public String toString() {
        return XE.h().a(this);
    }

    public String toString(String string) {
        if (string == null) {
            return this.toString();
        }
        return Xh.a(string).a(this);
    }

    public String toString(String string, Locale locale) {
        if (string == null) {
            return this.toString();
        }
        return Xh.a(string).a(locale).a(this);
    }

    static {
        TIME_DURATION_TYPES.add(UF.millis());
        TIME_DURATION_TYPES.add(UF.seconds());
        TIME_DURATION_TYPES.add(UF.minutes());
        TIME_DURATION_TYPES.add(UF.hours());
    }
}

