/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class UN
extends VA
implements Vi,
Serializable {
    private static final long serialVersionUID = -8775358157899L;
    private static final int YEAR = 0;
    private static final int MONTH_OF_YEAR = 1;
    private static final int DAY_OF_MONTH = 2;
    private static final Set<UF> DATE_DURATION_TYPES = new HashSet<UF>();
    private final long iLocalMillis;
    private final Un iChronology;
    private transient int iHash;

    public static UN now() {
        return new UN();
    }

    public static UN now(Uy uy2) {
        if (uy2 == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new UN(uy2);
    }

    public static UN now(Un un2) {
        if (un2 == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new UN(un2);
    }

    @FromString
    public static UN parse(String string) {
        return UN.parse(string, XE.a());
    }

    public static UN parse(String string, Xi xi2) {
        return xi2.a(string);
    }

    public static UN fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        int n2 = calendar.get(0);
        int n3 = calendar.get(1);
        return new UN(n2 == 1 ? n3 : 1 - n3, calendar.get(2) + 1, calendar.get(5));
    }

    public static UN fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (date.getTime() < 0L) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            return UN.fromCalendarFields(gregorianCalendar);
        }
        return new UN(date.getYear() + 1900, date.getMonth() + 1, date.getDate());
    }

    public UN() {
        this(Uv.a(), (Un)Wf.getInstance());
    }

    public UN(Uy uy2) {
        this(Uv.a(), (Un)Wf.getInstance(uy2));
    }

    public UN(Un un2) {
        this(Uv.a(), un2);
    }

    public UN(long l2) {
        this(l2, (Un)Wf.getInstance());
    }

    public UN(long l2, Uy uy2) {
        this(l2, (Un)Wf.getInstance(uy2));
    }

    public UN(long l2, Un un2) {
        un2 = Uv.a(un2);
        long l3 = un2.getZone().getMillisKeepLocal(Uy.UTC, l2);
        un2 = un2.withUTC();
        this.iLocalMillis = un2.dayOfMonth().roundFloor(l3);
        this.iChronology = un2;
    }

    public UN(Object object) {
        this(object, (Un)null);
    }

    public UN(Object object, Uy uy2) {
        WC wC2 = Wt.a().a(object);
        Un un2 = wC2.a(object, uy2);
        un2 = Uv.a(un2);
        this.iChronology = un2.withUTC();
        int[] nArray = wC2.a(this, object, un2, XE.a());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(nArray[0], nArray[1], nArray[2], 0);
    }

    public UN(Object object, Un un2) {
        WC wC2 = Wt.a().a(object);
        un2 = wC2.a(object, un2);
        un2 = Uv.a(un2);
        this.iChronology = un2.withUTC();
        int[] nArray = wC2.a(this, object, un2, XE.a());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(nArray[0], nArray[1], nArray[2], 0);
    }

    public UN(int n2, int n3, int n4) {
        this(n2, n3, n4, Wf.getInstanceUTC());
    }

    public UN(int n2, int n3, int n4, Un un2) {
        un2 = Uv.a(un2).withUTC();
        long l2 = un2.getDateTimeMillis(n2, n3, n4, 0);
        this.iChronology = un2;
        this.iLocalMillis = l2;
    }

    private Object readResolve() {
        if (this.iChronology == null) {
            return new UN(this.iLocalMillis, (Un)Wf.getInstanceUTC());
        }
        if (!Uy.UTC.equals(this.iChronology.getZone())) {
            return new UN(this.iLocalMillis, this.iChronology.withUTC());
        }
        return this;
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    protected Us getField(int n2, Un un2) {
        switch (n2) {
            case 0: {
                return un2.year();
            }
            case 1: {
                return un2.monthOfYear();
            }
            case 2: {
                return un2.dayOfMonth();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + n2);
    }

    @Override
    public int getValue(int n2) {
        switch (n2) {
            case 0: {
                return this.getChronology().year().get(this.getLocalMillis());
            }
            case 1: {
                return this.getChronology().monthOfYear().get(this.getLocalMillis());
            }
            case 2: {
                return this.getChronology().dayOfMonth().get(this.getLocalMillis());
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + n2);
    }

    @Override
    public int get(Ut ut2) {
        if (ut2 == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(ut2)) {
            throw new IllegalArgumentException("Field '" + ut2 + "' is not supported");
        }
        return ut2.getField(this.getChronology()).get(this.getLocalMillis());
    }

    @Override
    public boolean isSupported(Ut ut2) {
        if (ut2 == null) {
            return false;
        }
        UF uF2 = ut2.getDurationType();
        if (DATE_DURATION_TYPES.contains(uF2) || uF2.getField(this.getChronology()).getUnitMillis() >= this.getChronology().days().getUnitMillis()) {
            return ut2.getField(this.getChronology()).isSupported();
        }
        return false;
    }

    public boolean isSupported(UF uF2) {
        if (uF2 == null) {
            return false;
        }
        UE uE2 = uF2.getField(this.getChronology());
        if (DATE_DURATION_TYPES.contains(uF2) || uE2.getUnitMillis() >= this.getChronology().days().getUnitMillis()) {
            return uE2.isSupported();
        }
        return false;
    }

    @Override
    protected long getLocalMillis() {
        return this.iLocalMillis;
    }

    @Override
    public Un getChronology() {
        return this.iChronology;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof UN) {
            UN uN2 = (UN)object;
            if (this.iChronology.equals(uN2.iChronology)) {
                return this.iLocalMillis == uN2.iLocalMillis;
            }
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = this.iHash;
        if (n2 == 0) {
            n2 = this.iHash = super.hashCode();
        }
        return n2;
    }

    @Override
    public int compareTo(Vi vi2) {
        if (this == vi2) {
            return 0;
        }
        if (vi2 instanceof UN) {
            UN uN2 = (UN)vi2;
            if (this.iChronology.equals(uN2.iChronology)) {
                return this.iLocalMillis < uN2.iLocalMillis ? -1 : (this.iLocalMillis == uN2.iLocalMillis ? 0 : 1);
            }
        }
        return super.compareTo(vi2);
    }

    public Uq toDateTimeAtStartOfDay() {
        return this.toDateTimeAtStartOfDay(null);
    }

    public Uq toDateTimeAtStartOfDay(Uy uy2) {
        uy2 = Uv.a(uy2);
        Un un2 = this.getChronology().withZone(uy2);
        long l2 = this.getLocalMillis() + 21600000L;
        long l3 = uy2.convertLocalToUTC(l2, false);
        l3 = un2.dayOfMonth().roundFloor(l3);
        return new Uq(l3, un2).withEarlierOffsetAtOverlap();
    }

    @Deprecated
    public Uq toDateTimeAtMidnight() {
        return this.toDateTimeAtMidnight(null);
    }

    @Deprecated
    public Uq toDateTimeAtMidnight(Uy uy2) {
        uy2 = Uv.a(uy2);
        Un un2 = this.getChronology().withZone(uy2);
        return new Uq(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), 0, 0, 0, 0, un2);
    }

    public Uq toDateTimeAtCurrentTime() {
        return this.toDateTimeAtCurrentTime(null);
    }

    public Uq toDateTimeAtCurrentTime(Uy uy2) {
        uy2 = Uv.a(uy2);
        Un un2 = this.getChronology().withZone(uy2);
        long l2 = Uv.a();
        long l3 = un2.set(this, l2);
        return new Uq(l3, un2);
    }

    @Deprecated
    public Uo toDateMidnight() {
        return this.toDateMidnight(null);
    }

    @Deprecated
    public Uo toDateMidnight(Uy uy2) {
        uy2 = Uv.a(uy2);
        Un un2 = this.getChronology().withZone(uy2);
        return new Uo(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), un2);
    }

    public UP toLocalDateTime(UR uR2) {
        if (uR2 == null) {
            throw new IllegalArgumentException("The time must not be null");
        }
        if (this.getChronology() != uR2.getChronology()) {
            throw new IllegalArgumentException("The chronology of the time does not match");
        }
        long l2 = this.getLocalMillis() + uR2.getLocalMillis();
        return new UP(l2, this.getChronology());
    }

    public Uq toDateTime(UR uR2) {
        return this.toDateTime(uR2, null);
    }

    public Uq toDateTime(UR uR2, Uy uy2) {
        if (uR2 == null) {
            return this.toDateTimeAtCurrentTime(uy2);
        }
        if (this.getChronology() != uR2.getChronology()) {
            throw new IllegalArgumentException("The chronology of the time does not match");
        }
        Un un2 = this.getChronology().withZone(uy2);
        return new Uq(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), uR2.getHourOfDay(), uR2.getMinuteOfHour(), uR2.getSecondOfMinute(), uR2.getMillisOfSecond(), un2);
    }

    public UL toInterval() {
        return this.toInterval(null);
    }

    public UL toInterval(Uy uy2) {
        uy2 = Uv.a(uy2);
        Uq uq2 = this.toDateTimeAtStartOfDay(uy2);
        Uq uq3 = this.plusDays(1).toDateTimeAtStartOfDay(uy2);
        return new UL((Vg)uq2, (Vg)uq3);
    }

    public Date toDate() {
        Date date;
        int n2 = this.getDayOfMonth();
        Date date2 = new Date(this.getYear() - 1900, this.getMonthOfYear() - 1, n2);
        UN uN2 = UN.fromDateFields(date2);
        if (uN2.isBefore(this)) {
            while (!uN2.equals(this)) {
                date2.setTime(date2.getTime() + 3600000L);
                uN2 = UN.fromDateFields(date2);
            }
            while (date2.getDate() == n2) {
                date2.setTime(date2.getTime() - 1000L);
            }
            date2.setTime(date2.getTime() + 1000L);
        } else if (uN2.equals(this) && (date = new Date(date2.getTime() - (long)TimeZone.getDefault().getDSTSavings())).getDate() == n2) {
            date2 = date;
        }
        return date2;
    }

    UN withLocalMillis(long l2) {
        l2 = this.iChronology.dayOfMonth().roundFloor(l2);
        return l2 == this.getLocalMillis() ? this : new UN(l2, this.getChronology());
    }

    public UN withFields(Vi vi2) {
        if (vi2 == null) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().set(vi2, this.getLocalMillis()));
    }

    public UN withField(Ut ut2, int n2) {
        if (ut2 == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (!this.isSupported(ut2)) {
            throw new IllegalArgumentException("Field '" + ut2 + "' is not supported");
        }
        long l2 = ut2.getField(this.getChronology()).set(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UN withFieldAdded(UF uF2, int n2) {
        if (uF2 == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (!this.isSupported(uF2)) {
            throw new IllegalArgumentException("Field '" + uF2 + "' is not supported");
        }
        if (n2 == 0) {
            return this;
        }
        long l2 = uF2.getField(this.getChronology()).add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UN withPeriodAdded(Vj vj2, int n2) {
        if (vj2 == null || n2 == 0) {
            return this;
        }
        long l2 = this.getLocalMillis();
        Un un2 = this.getChronology();
        for (int i2 = 0; i2 < vj2.size(); ++i2) {
            long l3 = WS.b(vj2.getValue(i2), n2);
            UF uF2 = vj2.getFieldType(i2);
            if (!this.isSupported(uF2)) continue;
            l2 = uF2.getField(un2).add(l2, l3);
        }
        return this.withLocalMillis(l2);
    }

    public UN plus(Vj vj2) {
        return this.withPeriodAdded(vj2, 1);
    }

    public UN plusYears(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().years().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UN plusMonths(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().months().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UN plusWeeks(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().weeks().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UN plusDays(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().days().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UN minus(Vj vj2) {
        return this.withPeriodAdded(vj2, -1);
    }

    public UN minusYears(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().years().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UN minusMonths(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().months().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UN minusWeeks(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().weeks().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UN minusDays(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().days().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public UO property(Ut ut2) {
        if (ut2 == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(ut2)) {
            throw new IllegalArgumentException("Field '" + ut2 + "' is not supported");
        }
        return new UO(this, ut2.getField(this.getChronology()));
    }

    public int getEra() {
        return this.getChronology().era().get(this.getLocalMillis());
    }

    public int getCenturyOfEra() {
        return this.getChronology().centuryOfEra().get(this.getLocalMillis());
    }

    public int getYearOfEra() {
        return this.getChronology().yearOfEra().get(this.getLocalMillis());
    }

    public int getYearOfCentury() {
        return this.getChronology().yearOfCentury().get(this.getLocalMillis());
    }

    public int getYear() {
        return this.getChronology().year().get(this.getLocalMillis());
    }

    public int getWeekyear() {
        return this.getChronology().weekyear().get(this.getLocalMillis());
    }

    public int getMonthOfYear() {
        return this.getChronology().monthOfYear().get(this.getLocalMillis());
    }

    public int getWeekOfWeekyear() {
        return this.getChronology().weekOfWeekyear().get(this.getLocalMillis());
    }

    public int getDayOfYear() {
        return this.getChronology().dayOfYear().get(this.getLocalMillis());
    }

    public int getDayOfMonth() {
        return this.getChronology().dayOfMonth().get(this.getLocalMillis());
    }

    public int getDayOfWeek() {
        return this.getChronology().dayOfWeek().get(this.getLocalMillis());
    }

    public UN withEra(int n2) {
        return this.withLocalMillis(this.getChronology().era().set(this.getLocalMillis(), n2));
    }

    public UN withCenturyOfEra(int n2) {
        return this.withLocalMillis(this.getChronology().centuryOfEra().set(this.getLocalMillis(), n2));
    }

    public UN withYearOfEra(int n2) {
        return this.withLocalMillis(this.getChronology().yearOfEra().set(this.getLocalMillis(), n2));
    }

    public UN withYearOfCentury(int n2) {
        return this.withLocalMillis(this.getChronology().yearOfCentury().set(this.getLocalMillis(), n2));
    }

    public UN withYear(int n2) {
        return this.withLocalMillis(this.getChronology().year().set(this.getLocalMillis(), n2));
    }

    public UN withWeekyear(int n2) {
        return this.withLocalMillis(this.getChronology().weekyear().set(this.getLocalMillis(), n2));
    }

    public UN withMonthOfYear(int n2) {
        return this.withLocalMillis(this.getChronology().monthOfYear().set(this.getLocalMillis(), n2));
    }

    public UN withWeekOfWeekyear(int n2) {
        return this.withLocalMillis(this.getChronology().weekOfWeekyear().set(this.getLocalMillis(), n2));
    }

    public UN withDayOfYear(int n2) {
        return this.withLocalMillis(this.getChronology().dayOfYear().set(this.getLocalMillis(), n2));
    }

    public UN withDayOfMonth(int n2) {
        return this.withLocalMillis(this.getChronology().dayOfMonth().set(this.getLocalMillis(), n2));
    }

    public UN withDayOfWeek(int n2) {
        return this.withLocalMillis(this.getChronology().dayOfWeek().set(this.getLocalMillis(), n2));
    }

    public UO era() {
        return new UO(this, this.getChronology().era());
    }

    public UO centuryOfEra() {
        return new UO(this, this.getChronology().centuryOfEra());
    }

    public UO yearOfCentury() {
        return new UO(this, this.getChronology().yearOfCentury());
    }

    public UO yearOfEra() {
        return new UO(this, this.getChronology().yearOfEra());
    }

    public UO year() {
        return new UO(this, this.getChronology().year());
    }

    public UO weekyear() {
        return new UO(this, this.getChronology().weekyear());
    }

    public UO monthOfYear() {
        return new UO(this, this.getChronology().monthOfYear());
    }

    public UO weekOfWeekyear() {
        return new UO(this, this.getChronology().weekOfWeekyear());
    }

    public UO dayOfYear() {
        return new UO(this, this.getChronology().dayOfYear());
    }

    public UO dayOfMonth() {
        return new UO(this, this.getChronology().dayOfMonth());
    }

    public UO dayOfWeek() {
        return new UO(this, this.getChronology().dayOfWeek());
    }

    @ToString
    public String toString() {
        return XE.g().a(this);
    }

    public String toString(String string) {
        if (string == null) {
            return this.toString();
        }
        return Xh.a(string).a(this);
    }

    public String toString(String string, Locale locale) {
        if (string == null) {
            return this.toString();
        }
        return Xh.a(string).a(locale).a(this);
    }

    static {
        DATE_DURATION_TYPES.add(UF.days());
        DATE_DURATION_TYPES.add(UF.weeks());
        DATE_DURATION_TYPES.add(UF.months());
        DATE_DURATION_TYPES.add(UF.weekyears());
        DATE_DURATION_TYPES.add(UF.years());
        DATE_DURATION_TYPES.add(UF.centuries());
        DATE_DURATION_TYPES.add(UF.eras());
    }
}

