/*
 * Decompiled with CFR 0.152.
 */
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class UC
extends VE {
    public static final UC ZERO = new UC(0);
    public static final UC ONE = new UC(1);
    public static final UC TWO = new UC(2);
    public static final UC THREE = new UC(3);
    public static final UC FOUR = new UC(4);
    public static final UC FIVE = new UC(5);
    public static final UC SIX = new UC(6);
    public static final UC SEVEN = new UC(7);
    public static final UC MAX_VALUE = new UC(Integer.MAX_VALUE);
    public static final UC MIN_VALUE = new UC(Integer.MIN_VALUE);
    private static final XL PARSER = XG.a().a(UZ.days());
    private static final long serialVersionUID = 87525275727380865L;

    public static UC days(int n2) {
        switch (n2) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 4: {
                return FOUR;
            }
            case 5: {
                return FIVE;
            }
            case 6: {
                return SIX;
            }
            case 7: {
                return SEVEN;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new UC(n2);
    }

    public static UC daysBetween(Vg vg2, Vg vg3) {
        int n2 = VE.between(vg2, vg3, UF.days());
        return UC.days(n2);
    }

    public static UC daysBetween(Vi vi2, Vi vi3) {
        if (vi2 instanceof UN && vi3 instanceof UN) {
            Un un2 = Uv.a(vi2.getChronology());
            int n2 = un2.days().getDifference(((UN)vi3).getLocalMillis(), ((UN)vi2).getLocalMillis());
            return UC.days(n2);
        }
        int n3 = VE.between(vi2, vi3, ZERO);
        return UC.days(n3);
    }

    public static UC daysIn(Vh vh2) {
        if (vh2 == null) {
            return ZERO;
        }
        int n2 = VE.between(vh2.getStart(), vh2.getEnd(), UF.days());
        return UC.days(n2);
    }

    public static UC standardDaysIn(Vj vj2) {
        int n2 = VE.standardPeriodIn(vj2, 86400000L);
        return UC.days(n2);
    }

    @FromString
    public static UC parseDays(String string) {
        if (string == null) {
            return ZERO;
        }
        UY uY2 = PARSER.a(string);
        return UC.days(uY2.getDays());
    }

    private UC(int n2) {
        super(n2);
    }

    private Object readResolve() {
        return UC.days(this.getValue());
    }

    @Override
    public UF getFieldType() {
        return UF.days();
    }

    @Override
    public UZ getPeriodType() {
        return UZ.days();
    }

    public Vo toStandardWeeks() {
        return Vo.weeks(this.getValue() / 7);
    }

    public UH toStandardHours() {
        return UH.hours(WS.b(this.getValue(), 24));
    }

    public UT toStandardMinutes() {
        return UT.minutes(WS.b(this.getValue(), 1440));
    }

    public Vk toStandardSeconds() {
        return Vk.seconds(WS.b(this.getValue(), 86400));
    }

    public UD toStandardDuration() {
        long l2 = this.getValue();
        return new UD(l2 * 86400000L);
    }

    public int getDays() {
        return this.getValue();
    }

    public UC plus(int n2) {
        if (n2 == 0) {
            return this;
        }
        return UC.days(WS.a(this.getValue(), n2));
    }

    public UC plus(UC uC2) {
        if (uC2 == null) {
            return this;
        }
        return this.plus(uC2.getValue());
    }

    public UC minus(int n2) {
        return this.plus(WS.a(n2));
    }

    public UC minus(UC uC2) {
        if (uC2 == null) {
            return this;
        }
        return this.minus(uC2.getValue());
    }

    public UC multipliedBy(int n2) {
        return UC.days(WS.b(this.getValue(), n2));
    }

    public UC dividedBy(int n2) {
        if (n2 == 1) {
            return this;
        }
        return UC.days(this.getValue() / n2);
    }

    public UC negated() {
        return UC.days(WS.a(this.getValue()));
    }

    public boolean isGreaterThan(UC uC2) {
        if (uC2 == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > uC2.getValue();
    }

    public boolean isLessThan(UC uC2) {
        if (uC2 == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < uC2.getValue();
    }

    @ToString
    public String toString() {
        return "P" + String.valueOf(this.getValue()) + "D";
    }
}

