/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.border.Border;

public class Ee
extends Ec {
    private static final int DEFAULT_LINES = 1;
    private static final float DEFAULT_MIN_FONT = 9.0f;
    private boolean mIsScale = false;
    private Font mOriginalFont = null;
    private float mMinFontSize = 9.0f;
    private ArrayList<Db> mSpannableInfoList = null;
    private int mPaintStrIndex = 0;

    public Ee(int lines) {
        this(lines, false);
    }

    public Ee(boolean isScale) {
        this(1, isScale);
    }

    public Ee(boolean isScale, float minFontSize) {
        this(1, isScale, minFontSize);
    }

    public Ee(int lines, boolean isScale) {
        this(lines, isScale, 9.0f);
    }

    public Ee(int lines, boolean isScale, float minFontSize) {
        super(lines);
        this.mIsScale = isScale;
        this.mMinFontSize = minFontSize;
    }

    public void clearSpannableInfo() {
        this.mSpannableInfoList = null;
    }

    public void overwriteSpannableInfo(ArrayList<Db> spannableInfo) {
        this.mSpannableInfoList = spannableInfo;
    }

    public void addSpannableInfo(Db info) {
        if (info == null) {
            return;
        }
        if (this.mSpannableInfoList == null) {
            this.mSpannableInfoList = new ArrayList();
        }
        this.mSpannableInfoList.add(info);
    }

    public ArrayList<Db> getSpannableInfoList() {
        return this.mSpannableInfoList;
    }

    public void setScale(boolean isScale) {
        this.mIsScale = isScale;
    }

    public boolean getScale() {
        return this.mIsScale;
    }

    public void setMinFontSize(float fontSize) {
        this.mMinFontSize = fontSize;
    }

    public float getMinFontSize() {
        return this.mMinFontSize;
    }

    @Override
    protected void drawString(Graphics g2, String str, int x2, int y2) {
        if (str == null || str.length() == 0) {
            return;
        }
        if (this.mSpannableInfoList == null || this.mSpannableInfoList.isEmpty()) {
            super.drawString(g2, str, x2, y2);
            return;
        }
        int drawX = x2;
        StringBuilder sb2 = new StringBuilder(str);
        while (sb2.length() > 0) {
            String drawStr;
            int drawLen;
            Db spannableInfo = this.getSuitalbeSpannableInfo(this.mPaintStrIndex, this.mSpannableInfoList);
            if (spannableInfo == null || this.mPaintStrIndex + sb2.length() <= spannableInfo.a) {
                this.mPaintStrIndex += sb2.length();
                super.drawString(g2, sb2.toString(), drawX, y2);
                return;
            }
            if (this.mPaintStrIndex < spannableInfo.a) {
                drawLen = spannableInfo.a - this.mPaintStrIndex;
                drawStr = sb2.substring(0, drawLen);
                sb2.delete(0, drawLen);
                super.drawString(g2, drawStr, drawX, y2);
                drawX += this.measureStrWidth(drawStr, g2);
                this.mPaintStrIndex = spannableInfo.a;
            }
            if (this.mPaintStrIndex < spannableInfo.a) continue;
            drawLen = Math.min(sb2.length(), spannableInfo.b);
            drawStr = sb2.substring(0, drawLen);
            sb2.delete(0, drawLen);
            this.drawSpannable(g2, drawStr, drawX, y2, spannableInfo.a, spannableInfo.a);
            drawX += this.measureStrWidth(drawStr, g2);
            this.mPaintStrIndex += drawLen;
        }
    }

    private void drawSpannable(Graphics g2, String drawStr, int drawX, int y2, Color spannableColor, boolean spannableStrike) {
        Color oldColor = g2.getColor();
        if (spannableColor == null) {
            spannableColor = oldColor;
        }
        g2.setColor(spannableColor);
        super.drawString(g2, drawStr, drawX, y2);
        if (spannableStrike) {
            Font font = g2.getFont();
            FontMetrics fm2 = super.getFontMetrics(font);
            int y22 = y2 - (fm2.getAscent() - fm2.getDescent() >> 1);
            int strWidth = fm2.stringWidth(drawStr);
            g2.drawLine(drawX, y22, drawX + strWidth, y22);
        }
        g2.setColor(oldColor);
    }

    private Db getSuitalbeSpannableInfo(int mPaintStrCount, ArrayList<Db> spannableInfoList) {
        for (Db info : spannableInfoList) {
            if (info == null || info.a + info.b <= mPaintStrCount) continue;
            return info;
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g2) {
        if (this.mIsScale) {
            this.initScaleFont(g2);
        }
        this.resetPaintStrCount();
        super.paintComponent(g2);
    }

    @Override
    protected Font getPaintFont(Graphics g2) {
        return g2.getFont();
    }

    private void resetPaintStrCount() {
        this.mPaintStrIndex = 0;
    }

    private void initScaleFont(Graphics g2) {
        String text;
        if (this.mOriginalFont == null) {
            this.mOriginalFont = super.getFont();
        }
        if (!F.a(text = this.getText()) && this.mIsScale) {
            int w2 = this.getPaintWidth();
            this.setSuitableFont(g2, this.mOriginalFont.deriveFont(this.mMinFontSize), this.mOriginalFont, text, w2);
        }
    }

    protected int getPaintWidth() {
        int w2 = this.getWidth();
        Border border = super.getBorder();
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            w2 -= insets.right + insets.left;
        }
        return w2;
    }

    private void setSuitableFont(Graphics g2, Font minFont, Font maxFont, String text, int w2) {
        if (maxFont.getSize() <= minFont.getSize()) {
            g2.setFont(minFont);
            return;
        }
        int start = minFont.getSize();
        int end = maxFont.getSize();
        while (start < end) {
            int mid = end - (end - start >> 1);
            Font midFont = maxFont.deriveFont((float)mid);
            FontMetrics fm2 = super.getFontMetrics(midFont);
            if (fm2.stringWidth(text) <= w2) {
                start = mid;
                continue;
            }
            end = mid - 1;
        }
        Font suitableFont = maxFont.deriveFont((float)start);
        g2.setFont(suitableFont);
    }

    private int measureStrWidth(String s2, Graphics g2) {
        return g2.getFontMetrics().stringWidth(s2);
    }

    private float getMidSize(int start, int end) {
        int mid = end - (end - start >> 1);
        return mid;
    }
}

