from time import sleep
from machine import UART

uart = UART(0, 115200)  # init with given baudrate
uart.init(115200, bits=8, parity=None, stop=1)

import uos
uos.dupterm(None, 1)

import esp
esp.uart_swap()
def count_time(i):
    sleep(0.0015)
    if i < 100:
        tag = True
    else:
        tag = False
    return tag
def wait():
    tag = True
    i = 0
    while tag:
      value = uart.read()
      i +=1
      tag = count_time(i)
      if value:
        return value
    return [0,0,1,0,0,0,0,0,0,0,0,0]  # 使得获取传感器的返回值为False
    
def send_value(a):
    if type(a) == list:
        b = uart.write("setTrack(%s,%s,%s)\\n" %(a[0],a[1],a[2]))
        b = wait()
        b = list(b)
    else:
        b = uart.write(a)
        b = wait()
        b = list(b)
    
# 提取出五个IR传感器的状态值。0表示检测到黑线,返回列表
def get_IR_state(sta):
    state=[2,2,2,2,2]
    state[0] = 1 if sta & 16==16 else 0
    state[1] = 1 if sta & 8==8 else 0
    state[2] = 1 if sta & 4==4 else 0
    state[3] = 1 if sta & 2==2 else 0
    state[4] = 1 if sta & 1==1 else 0
    return state
    
#得到的传感器的状态与期望值比较
def line_track(a):
    b = uart.write("getTrack_value()\\n")
    b = wait()
    b = list(b)
    i = -1
    try:
      if 4 == b[3] and b[4] == 54 and ((b[2] + b[3] + b[4] + b[5] +b[6]) == b[7]):
          IR_state = get_IR_state(b[6])
      else:
          return False
      for item1 in a:
          i += 1
          if item1 == 2:
              continue
          else:
              if item1 == IR_state[i]:
                  continue
              else:
                  return False
      return True
    except Exception as e:
      return False

# 巡线直行时防止走偏
def straight(a):
    b = uart.write("getTrack_value()\\n")
    b = wait()
    b = list(b)
    try:
      if 4 == b[3] and b[4] == 54 and ((b[2] + b[3] + b[4] + b[5] +b[6]) == b[7]):
          IR_state = get_IR_state(b[6])
      else:
          return False
      for i in a.values():
          k = 0
          for j in range(4):
              if i[j]==2:
                  continue
              else:
                  if i[j] == IR_state[j]:
                      k+=1
                      if k == 3:
                          return "setTrack(%s,%s,%s)\\n" %(i[5],i[6],i[7])
                  else:break
      return False
    except Exception as e:
      return False

def line_straight(a):
    info = straight(a)
    if info:
      uart.write(info)
      b = wait()
      return True
    else:
      return False

# 转弯
def line_turn(a):
    sleep(a[4])
    uart.write("setTrack(%s,%s,%s)" % (a[1], a[2], a[3]))
    wait()
    tag = True
    try:
      while tag:
          b = uart.write("getTrack_value()\\n")
          b = wait()
          b = list(b)
          if 4 == b[3] and b[4] == 54 and ((b[2] + b[3] + b[4] + b[5] +b[6]) == b[7]):
              IR_state = get_IR_state(b[6])
          else:
              continue
          if IR_state[a[0]] == 0:
              tag = False
              sleep(a[5])
          else:
              continue
    except Exception as e:
      return False

# RF遥控器

def remocon(info):
    b = uart.write("getRemoconValue()\\n")
    b = wait()
    b = list(b)     #字节对象转列表
    try:
      if 4 == b[3] and b[4] == 26 and ((b[2] + b[3] + b[4] + b[5] +b[6]) == b[7]):
          if b[6] == info:
            return True
          else:
            return False
      else:
          return False
    except Exception as e:
      return False


