/*
noMeiryoUI (C) 2005,2012-2020 Tatsuhiko Shoji
The sources for noMeiryoUI are distributed under the MIT open source license
*/
// noMeiryoUI.cpp : AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"

#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <process.h>
#include <Objbase.h>
#include <shellapi.h>
#include <locale.h>
#include <mbctype.h>
#include "noMeiryoUI.h"
#include "FontSel.h"
#include "NCFileDialog.h"
#include "util.h"
#include "resource.h"

#define MAX_LOADSTRING 100

//
// _CAOx[XAvP[Vt[[N
// [U[̃ubW[`
//

// AvP[VIuWFNg
NoMeiryoUI *appObj;
static bool use7Compat = true;
bool useResource = false;
bool has8Preset = true;
bool has10Preset = true;
TCHAR helpFileName[MAX_PATH];
RECT myMonitorLect;
bool firstMonitor = false;
DWORD helpPid;
bool helpMoved = false;

/**
 * AvP[VIuWFNg쐬܂B
 */
DialogAppliBase *createAppli()
{
	CoInitialize(NULL);

	initializeLocale();

	// Ń[U[̃AvP[VIuWFNg쐬܂B
	appObj = new NoMeiryoUI();
	return appObj;
}

/**
 * e̔Ɗeɍ킹s܂B
 */
void initializeLocale(void)
{
	TCHAR iniPath[MAX_PATH];
	TCHAR *p;
	TCHAR langWork[64];
	TCHAR findPath[MAX_PATH];
	TCHAR langFileName[MAX_PATH];

	::GetModuleFileName(NULL, iniPath, _MAX_PATH);
	p = _tcsrchr(iniPath, '\\');
	if (p != NULL) {
		*(p + 1) = '\0';
	}

	// P[̏
	char *localeName = setlocale(LC_ALL, "");
	char *codePageDelim = strchr(localeName, '.');
	if (codePageDelim != NULL) {
		_setmbcp(atoi(codePageDelim + 1));
		codePage = atoi(codePageDelim + 1);
	} else {
		_setmbcp(_MB_CP_LOCALE);
		codePageDelim = 0;
	}
	mbstowcs(langWork, localeName, 64);

	//localeName = "aaa";
	int readResult;
	if (strstr(localeName, "Japanese_Japan") != NULL) {
		useResource = false;
		setFontResourceJa8();
		setFontResourceJa10();
		_tcscpy(helpFileName, _T("Japanese.chm"));
	} else {
		// Language detection
		useResource = true;

		if (strstr(localeName, "_Korea") != NULL) {
			isKorean = true;
		}

		_tcscpy(findPath, iniPath);
		p = _tcsrchr(langWork, _T('.'));
		if (p != NULL) {
			*p = _T('\0');
		}
		_tcscat(findPath, langWork);
		_tcscat(findPath, _T(".lng"));
		WIN32_FIND_DATA fileInfo;
		
		HANDLE found = FindFirstFile(findPath, &fileInfo);
		if (found != INVALID_HANDLE_VALUE) {
			// _n`̃t@Cꍇ
			_tcscpy(langFileName, findPath);

			_tcscpy(helpFileName, langWork);
			_tcscat(helpFileName, _T(".chm"));
		}
		else {
			_tcscpy(findPath, iniPath);
			p = _tcsrchr(langWork, _T('_'));
			if (p != NULL) {
				*p = _T('\0');
			}
			_tcscat(findPath, langWork);
			_tcscat(findPath, _T(".lng"));
			found = FindFirstFile(findPath, &fileInfo);
			if (found != INVALID_HANDLE_VALUE) {
				// ̃t@Cꍇ
				_tcscpy(langFileName, findPath);

				_tcscpy(helpFileName, langWork);
				_tcscat(helpFileName, _T(".chm"));
			} else {
				// t@C݂Ȃꍇ
				_tcscpy(langFileName, iniPath);

				_tcscpy(helpFileName, iniPath);
				_tcscat(helpFileName, _T("English.chm"));
			}
		}
		// Language support routine ends here.

		readResourceFile(langFileName);
		readResult = readFontResource8(langFileName);
		if (!readResult) {
			has8Preset = false;
		}
		readResult = readFontResource10(langFileName);
		if (!readResult) {
			has10Preset = false;
		}
	}
}

/**
 * _CAOv[VW
 *
 * @return TRUE: FALSE:Ȃ
 */
INT_PTR CALLBACK MainDialogProc(
  HWND hwndDlg,  // _CAO{bNX̃nh
  UINT uMsg,     // bZ[W
  WPARAM wParam, // ŏ̃bZ[Wp[^
  LPARAM lParam  // 2 Ԗڂ̃bZ[Wp[^
  )
{
	// [U[AvP[Ṽ_CAOv[VWɊۓ܂B
	return appObj->dialogProc(hwndDlg, uMsg,wParam,lParam);
}

//
// _CAOx[XAvP[Vt[[N̎
//

/**
 * AvP[VEChENX̃CX^X𐶐܂B
 *
 * @return AvP[VEChENX̃CX^X
 */
BaseDialog *NoMeiryoUI::createBaseDialog()
{
	return appObj;
}

/**
 * AvP[V̊Jns܂B
 *
 * @param lpCmdLine R}hC
 * @return \
 */
int NoMeiryoUI::OnAppliStart(TCHAR *lpCmdLine)
{
	// AvŗL̏s܂B
	noMeiryoUI = false;
	noTahoma = false;
	setOnStart = false;
	_tcscpy(settingFile, _T(""));
	verInfo = NULL;

	displayFont = NULL;
	allFont = NULL;
	titleFont = NULL;
	iconFontHandle = NULL;
	paletteFont = NULL;
	hintFont = NULL;
	messageFont = NULL;
	menuFont = NULL;

	allFontTextBox = NULL;
	titleFontTextBox = NULL;
	iconFontTextBox = NULL;
	paletteFontTextBox = NULL;
	hintFontTextBox = NULL;
	messageFontTextBox = NULL;
	menuFontTextBox = NULL;

	DWORD dwVersion = GetVersion();

	DWORD major = (DWORD)(LOBYTE(LOWORD(dwVersion)));
	DWORD minor = (DWORD)(HIBYTE(LOWORD(dwVersion)));
	if (major < 6) {
		// Windows XP or earlyer
		WIN8_SIZE = false;
		use7Compat = false;
	} else if (major == 6) {
		if (minor < 2) {
			// Windows Vista/7
			WIN8_SIZE = false;
			use7Compat = false;
		} else {
			// Windows 8/8.1
			WIN8_SIZE = true;
			use7Compat = true;
		}
	} else {
		// Windows 10 or later
		WIN8_SIZE = false;
		use7Compat = false;
	}

	// IvV擾B
	getOption(lpCmdLine);

	return 0;
}

/**
 * AvP[V̏Is܂B
 *
 * @return \
 */
int NoMeiryoUI::OnAppliEnd()
{
	// ̊֐I[o[ChăAvŗĽ㏈s܂B
	if (verInfo != NULL) {
		delete verInfo;
	}

	if (allFont != NULL) {
		DeleteObject(allFont);
	}
	if (titleFont != NULL) {
		DeleteObject(titleFont);
	}
	if (iconFontHandle != NULL) {
		DeleteObject(iconFontHandle);
	}
	if (paletteFont != NULL) {
		DeleteObject(paletteFont);
	}
	if (hintFont != NULL) {
		DeleteObject(hintFont);
	}
	if (messageFont != NULL) {
		DeleteObject(messageFont);
	}
	if (menuFont != NULL) {
		DeleteObject(menuFont);
	}

	if (allFontTextBox != NULL) {
		delete allFontTextBox;
	}
	if (titleFontTextBox != NULL) {
		delete titleFontTextBox;
	}
	if (iconFontTextBox != NULL) {
		delete iconFontTextBox;
	}
	if (paletteFontTextBox != NULL) {
		delete paletteFontTextBox;
	}
	if (hintFontTextBox != NULL) {
		delete hintFontTextBox;
	}
	if (messageFontTextBox != NULL) {
		delete messageFontTextBox;
	}
	if (menuFontTextBox != NULL) {
		delete menuFontTextBox;
	}

	if (displayFont != NULL) {
		DeleteObject(displayFont);
	}

	return 0;
}

//
// _CAOx[XAvP[VƂĂ
// AvP[VŗL̎
//

/**
 * _CAO
 *
 * @return TRUE:tH[JXݒ肵 FALSE:tH[JXݒ肵Ȃ
 */
INT_PTR NoMeiryoUI::OnInitDialog()
{
	// eNX̃_CAOĂԁB
	DialogAppliBase::OnInitDialog();

	// AvP[VACR̐ݒ
	HICON hIcon;

    hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDC_MYICON), IMAGE_ICON, 16, 16, 0);
    SendMessage(this->hWnd, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);

	appMenu = new TwrMenu(this->hWnd);

	if (!use7Compat) {
		// Windows 7ȑȌꍇ̓tHgTCY̎舵[hύXłȂB
		appMenu->setEnabled(IDM_COMPAT7, false);
	}
	appMenu->CheckMenuItem(IDM_ANOTHER, true);

	if (useResource) {
		// COł͏ݒ̃tHgقȂ̂ŃvZbgj[
		// ꍇ̂݃vZbgLɂB
		appMenu->setEnabled(IDM_SET_8, has8Preset);
		appMenu->setEnabled(IDM_SET_10, has10Preset);
	}

	// Windows 8.1ȑOłWindows 10ɂtHgȂꍇ̂
	// Windows 10p̃vZbggpsƂB
	DWORD dwVersion = GetVersion();

	DWORD major = (DWORD)(LOBYTE(LOWORD(dwVersion)));
	DWORD minor = (DWORD)(HIBYTE(LOWORD(dwVersion)));
	if (major < 10) {
		appMenu->setEnabled(IDM_SET_10, false);
	}


	// tHg擾p\̂̏
	FillMemory(&metrics, sizeof(NONCLIENTMETRICS), 0x00);
	FillMemory(&metricsAll, sizeof(NONCLIENTMETRICS), 0x00);
	FillMemory(&iconFont, sizeof(LOGFONT), 0x00);
	FillMemory(&iconFontAll, sizeof(LOGFONT), 0x00);

	// ݂̃tHg擾B
	if (settingFile[0] == _T('\0')) {
		getActualFont();
	} else {
		// ݂̃tHgƕtʊȅ̕擾ĂB
		getActualFont();

		BOOL loadResult = loadFontInfo(settingFile);
		if (loadResult) {
			if (setOnStart) {
				// -setIvVw肳ꂽꍇ̓tHgݒ肵ă_CAOB
				OnBnClickedOk();
				EndDialog(hWnd, 0);

				return (INT_PTR)FALSE;
			} else {
				// j[tHgׂ̏ẴtHg̊etHg̏ɂĂB
				metricsAll.lfMenuFont = metrics.lfMenuFont;
				metricsAll.lfStatusFont = metricsAll.lfMenuFont;
				metricsAll.lfMessageFont = metricsAll.lfMenuFont;
				metricsAll.lfCaptionFont = metricsAll.lfMenuFont;
				metricsAll.lfSmCaptionFont = metricsAll.lfMenuFont;
				iconFontAll = metricsAll.lfMenuFont;
			}
		} else {
			// ǂݍݎs͔Ôߍēx݂̃tHg̏
			// 擾ĂB
			getActualFont();
		}
	}

	if (useResource) {
		// {ȊOOSŋNĂꍇ
		// UI\[Xɍ킹ĕύXB
		applyResource();
	}
	// C_CAÕo[W\Lݒ
	TCHAR buf[64];
	TCHAR verString[32];
	const TCHAR *appName;
	LoadString(hInst, IDS_VERSION, verString, 32);
	if (useResource) {
		appName = langResource[1].c_str();
	} else {
		appName = _T("Meiryo UI炢!!");
	}
	_stprintf(buf, verString, appName);
	setChildText(IDC_STATIC_APP_TITLE, buf);


	// tHg\XVB
	updateDisplay();

	EnumDisplayMonitors(NULL, NULL, MonitorNearMouseCallback, 0);

	adjustCenter(myMonitorLect, HWND_TOP, this->hWnd);

	return (INT_PTR)FALSE;
}

/**
 * J[\̂郂j^[𔻒肷邽߂EnumDisplayMonitors̃R[obN
 *
 * @param hMonitor j^[̃nh
 * @param hdcMonitor j^[̃fBXvCReLXg
 * @param lprcMonitor j^[̍W
 * @param dwData EnumDisplayMonitors
 * @return TRUE:񋓂𑱂 FALSE:񋓂߁Aj^[̍Wm肳
 */
BOOL CALLBACK MonitorNearMouseCallback(
	HMONITOR hMonitor,
	HDC hdcMonitor,
	LPRECT lprcMonitor,
	LPARAM dwData
)
{
	if (!firstMonitor) {
		// fBXvC̏񂪉ȂԂ͔B
		myMonitorLect = *lprcMonitor;
		firstMonitor = true;
	}

	CURSORINFO cursofInfo;
	cursofInfo.cbSize = sizeof(CURSORINFO);
	BOOL result = GetCursorInfo(&cursofInfo);
	if (result == 0) {
		// J[\̏𗘗płȂƂ̓vC}j^
		// J[\̂郂j^ƂB
		if ((myMonitorLect.left == 0) && (myMonitorLect.top == 0)) {
			myMonitorLect = *lprcMonitor;
			return FALSE;
		} else {
			return TRUE;
		}
	}

	// J[\̂郂j^ǂ肷B
	int x = cursofInfo.ptScreenPos.x;
	int y = cursofInfo.ptScreenPos.y;
	if ((x >= lprcMonitor->left) && (x <= lprcMonitor->right)) {
		if ((y >= lprcMonitor->top) && (y <= lprcMonitor->bottom)) {
			myMonitorLect = *lprcMonitor;

			return FALSE;
		}
	}
	return TRUE;
}

/**
 * EChE\ꂽƂ̏s܂B<br>
 * EChEx[XAvƃC^tF[X킹邽߂ɗpӂĂ܂B
 *
 * @return \
 */
int NoMeiryoUI::OnWindowShow()
{

	// ̊֐I[o[ChāA̕\̏s܂B
	// ̃^C~OŃ_CAÔ݂ŁAɏ邱Ƃ
	// _CAOԂŋN̏sƂł܂B

	SetWinVer();

	// eLXg{bNXpɃ_CAO̊eeLXg{bNX擾B
	allFontTextBox = GetDlgItem(IDC_EDIT_ALL);
	titleFontTextBox = GetDlgItem(IDC_EDIT_TITLE);
	iconFontTextBox = GetDlgItem(IDC_EDIT_ICON);
	paletteFontTextBox = GetDlgItem(IDC_EDIT_PALETTE);
	hintFontTextBox = GetDlgItem(IDC_EDIT_HINT);
	messageFontTextBox = GetDlgItem(IDC_EDIT_MESSAGE);
	menuFontTextBox = GetDlgItem(IDC_EDIT_MENU);

	return 0;
}

/**
 * R}hCIvV擾B
 *
 * @param lpCmdLine R}hC
 */
void NoMeiryoUI::getOption(TCHAR *lpCmdLine)
{
	TCHAR *p;
	TCHAR *paramStart;
	bool firstCommand = false;
	bool capturing = false;
	TCHAR delimiter;
	int argCount = 0;

	p = lpCmdLine;
	while (*p != _T('\0')) {
		if (*p == _T('\"')) {
			if (!capturing) {
				capturing = true;
				delimiter = _T('\"');
				// ̕p[^Jn
				paramStart = p + 1;
			} else {
				if (delimiter == _T('\"')) {
					// ͒ŋ؂蕶_uNH[e[V̏ꍇ
					// p[^IƂB
					capturing = false;
					*p = _T('\0');
					argCount++;
					// Ńp[^̌ɉsB
					parseOption(paramStart, argCount);
				}
			}
		} else if (_istspace(*p)) {
			// 󔒂̏ꍇ
			if (capturing) {
				if (delimiter != _T('\"')) {
					// ͒ŋ؂蕶_uNH[e[VłȂꍇ
					// p[^IƂB
					capturing = false;
					*p = _T('\0');
					argCount++;
					// Ńp[^̌ɉsB
					parseOption(paramStart, argCount);
				}
			}
		} else {
			if (!capturing) {
				// p[^Jn
				capturing = true;
				paramStart = p;
				delimiter = _T(' ');
			}
		}
		p++;
	}
	if (capturing) {
		// ܂R}hC͂Ă炱܂łR}hCƂB
		argCount++;
		// Ńp[^̌ɉsB
		parseOption(paramStart, argCount);
	}

}

/**
 * IvV̈ʒuɉ͂sB
 *
 * @param param p[^
 * @param argCount IvV̌
 */
void NoMeiryoUI::parseOption(TCHAR *param, int argCount)
{
	switch (argCount) {
		case 1:
			// ݒt@C
			if (_tcscmp(_T("--"), param)) {
				if ((_tcschr(param, '\\') == NULL) && (_tcschr(param, '/') == NULL)) {
					GetCurrentDirectory(MAX_PATH, settingFile);
					_tcscat(settingFile, _T("\\"));
				} else {
					settingFile[0] = _T('\0');
				}
				_tcscat(settingFile, param);
			}
			break;
		default:
			if (!_tcscmp(param, _T("-set"))) {
				setOnStart = true;
			} else if (!_tcscmp(param, _T("noMeiryoUI"))) {
				noMeiryoUI = true;
			} else if (!_tcscmp(param, _T("noTahoma"))) {
				noTahoma = true;
			}

			break;
	}
}

/**
 * ݐݒ肳ĂtHg擾B
 */
void NoMeiryoUI::getActualFont(void)
{
	//
	// ʂ̃tHgp̏擾
	//

	// ACRȊÕtHg擾B
	metrics.cbSize = sizeof(NONCLIENTMETRICS);
	SystemParametersInfo(SPI_GETNONCLIENTMETRICS,
		sizeof(NONCLIENTMETRICS),
		&metrics,
		0);

	// ACR̃tHg擾B
	SystemParametersInfo(SPI_GETICONTITLELOGFONT,
		sizeof(LOGFONT),
		&iconFont,
		0);

	//
	// ׂẴtHgp̏擾
	//

	// ACRȊÕtHg擾B
	metricsAll.cbSize = sizeof(NONCLIENTMETRICS);
	SystemParametersInfo(SPI_GETNONCLIENTMETRICS,
		sizeof(NONCLIENTMETRICS),
		&metricsAll,
		0);

	// ACR̃tHg擾B
	SystemParametersInfo(SPI_GETICONTITLELOGFONT,
		sizeof(LOGFONT),
		&iconFontAll,
		0);

	// j[tHg̏𑼂̃tHg̏ɂĂB
	metricsAll.lfStatusFont = metricsAll.lfMenuFont;
	metricsAll.lfMessageFont = metricsAll.lfMenuFont;
	metricsAll.lfCaptionFont = metricsAll.lfMenuFont;
	metricsAll.lfSmCaptionFont = metricsAll.lfMenuFont;
	iconFontAll = metricsAll.lfMenuFont;
}

/**
 * tHg񂩂tHg̃nh쐬B
 *
 * @param font tHg̏
 * @return tHgnh
 */
HFONT NoMeiryoUI::createFont(LOGFONT *font)
{
	HDC hDC = GetDC(this->hWnd);

	HFONT newFont = CreateFont(
		-MulDiv(APP_FONTSIZE, GetDeviceCaps(hDC, LOGPIXELSY), 72),
		0,
		0,
		0,
		font->lfWeight,
		font->lfItalic,
		font->lfUnderline,
		font->lfStrikeOut,
		font->lfCharSet,
		OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS,
		PROOF_QUALITY, // CLEARTYPE_QUALITY,
		FIXED_PITCH | FF_MODERN,
		font->lfFaceName);

	ReleaseDC(this->hWnd, hDC);

	return newFont;
}

/**
 * _CAORg[ƃIuWFNg̓e̓B
 *
 * @param toObj true:Rg[IuWFNg false:IuWFNgRg[
 */
void NoMeiryoUI::UpdateData(bool toObj)
{
	// Ƀ_CAÕRg[Ɠ郁oϐLq܂B
	DDX_Text(toObj,IDC_EDIT_ALL, allFontName);
	DDX_Text(toObj,IDC_EDIT_TITLE, titleFontName);
	DDX_Text(toObj,IDC_EDIT_ICON, iconFontName);
	DDX_Text(toObj,IDC_EDIT_PALETTE, paletteFontName);
	DDX_Text(toObj,IDC_EDIT_HINT, hintFontName);
	DDX_Text(toObj,IDC_EDIT_MESSAGE, messageFontName);
	DDX_Text(toObj,IDC_EDIT_MENU, menuFontName);
}

/**
 * \[Xeڂɐݒ肷B
 */
void NoMeiryoUI::applyResource()
{
	HDC hDC = GetDC(this->hWnd);

	HFONT displayFont = CreateFont(
		-MulDiv(APP_FONTSIZE, GetDeviceCaps(hDC, LOGPIXELSY), 72),
		0,
		0,
		0,
		FW_NORMAL,
		FALSE,
		FALSE,
		FALSE,
		_tstoi(langResource[70].c_str()),
		OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS,
		PROOF_QUALITY, // CLEARTYPE_QUALITY,
		FIXED_PITCH | FF_MODERN,
		langResource[0].c_str());

	ReleaseDC(this->hWnd, hDC);


	// Av^Cg
	setText(langResource[1].c_str());

	// j[ύX
	appMenu->setText(0, langResource[2].c_str(), TRUE);
	appMenu->setText(IDM_OPEN, langResource[3].c_str(), FALSE);
	appMenu->setText(IDM_SAVE, langResource[4].c_str(), FALSE);
	appMenu->setText(IDOK, langResource[5].c_str(), FALSE);
	appMenu->setText(IDM_EXIT, langResource[6].c_str(), FALSE);
	appMenu->setText(1, langResource[7].c_str(), TRUE);
	appMenu->setText(IDM_SET_8, langResource[8].c_str(), FALSE);
	appMenu->setText(IDM_SET_10, langResource[9].c_str(), FALSE);
	appMenu->setText(2, langResource[10].c_str(), TRUE);
	appMenu->setText(IDM_ANOTHER, langResource[11].c_str(), FALSE);
	appMenu->setText(IDM_COMPAT7, langResource[12].c_str(), FALSE);
	appMenu->setText(3, langResource[13].c_str(), TRUE);
	appMenu->setText(IDM_HELPTOPIC, langResource[14].c_str(), FALSE);
	appMenu->setText(IDM_ABOUT, langResource[15].c_str(), FALSE);

	setChildText(IDC_STATIC_ALL_FONT, langResource[16].c_str());
	setChildFont(IDC_STATIC_ALL_FONT, displayFont);
	setChildText(IDC_STATIC_TITLE_BAR, langResource[17].c_str());
	setChildFont(IDC_STATIC_TITLE_BAR, displayFont);
	setChildText(IDC_STATIC_ICON, langResource[18].c_str());
	setChildFont(IDC_STATIC_ICON, displayFont);
	setChildText(IDC_STATIC_PALETTE_TITLE, langResource[19].c_str());
	setChildFont(IDC_STATIC_PALETTE_TITLE, displayFont);
	setChildText(IDC_STATIC_HINT, langResource[20].c_str());
	setChildFont(IDC_STATIC_HINT, displayFont);
	setChildText(IDC_STATIC_MESSAGE, langResource[21].c_str());
	setChildFont(IDC_STATIC_MESSAGE, displayFont);
	setChildText(IDC_STATIC_MENU, langResource[22].c_str());
	setChildFont(IDC_STATIC_MENU, displayFont);

	setChildText(ID_SEL_ALL, langResource[23].c_str());
	setChildFont(ID_SEL_ALL, displayFont);
	setChildText(ID_SEL_TITLE, langResource[23].c_str());
	setChildFont(ID_SEL_TITLE, displayFont);
	setChildText(ID_SEL_ICON, langResource[23].c_str());
	setChildFont(ID_SEL_ICON, displayFont);
	setChildText(ID_SEL_PALETTE, langResource[23].c_str());
	setChildFont(ID_SEL_PALETTE, displayFont);
	setChildText(ID_SEL_HINT, langResource[23].c_str());
	setChildFont(ID_SEL_HINT, displayFont);
	setChildText(ID_SEL_MESSAGE, langResource[23].c_str());
	setChildFont(ID_SEL_MESSAGE, displayFont);
	setChildText(ID_SEL_MENU, langResource[23].c_str());
	setChildFont(ID_SEL_MENU, displayFont);
	setChildText(ID_SET_ALL, langResource[24].c_str());
	setChildFont(ID_SET_ALL, displayFont);
	setChildText(IDOK, langResource[25].c_str());
	setChildFont(IDOK, displayFont);
	setChildText(IDCANCEL, langResource[26].c_str());
	setChildFont(IDCANCEL, displayFont);

	setChildText(ID_APPLY, langResource[71].c_str());
	setChildFont(ID_APPLY, displayFont);
	setChildText(ID_APPLY_ALL, langResource[71].c_str());
	setChildFont(ID_APPLY_ALL, displayFont);

	setChildText(IDC_GROUP_ALL, langResource[72].c_str());
	setChildFont(IDC_GROUP_ALL, displayFont);

	setChildText(IDC_GROUP_INDIVIDUAL, langResource[73].c_str());
	setChildFont(IDC_GROUP_INDIVIDUAL, displayFont);

	setChildFont(IDC_STATIC_APP_TITLE, displayFont);

	setChildFont(IDC_STATIC_VERNO, displayFont);
	setChildFont(IDC_STATIC_AUTHOR, displayFont);


	//DeleteObject(newFont);
}


/**
 * tHg\XVB
 */
void NoMeiryoUI::updateDisplay(void)
{
	// tHgA|Cg\쐬B
	int point;
	TCHAR buf[16];
	TCHAR dispName[32];

	allFontName = metricsAll.lfMenuFont.lfFaceName;
	if (isKorean) {
		_tcscpy(dispName, allFontName.c_str());
		getKoreanFontName(dispName);
		allFontName = dispName;
	}
	point = getFontPointInt(&(metricsAll.lfMenuFont), this->getHwnd());
	_stprintf(buf, _T(" %3dpt"), point);
	allFontName = allFontName + buf;

	titleFontName = metrics.lfCaptionFont.lfFaceName;
	if (isKorean) {
		_tcscpy(dispName, titleFontName.c_str());
		getKoreanFontName(dispName);
		titleFontName = dispName;
	}
	point = getFontPointInt(&(metrics.lfCaptionFont), this->getHwnd());
	_stprintf(buf, _T(" %3dpt"), point);
	titleFontName = titleFontName + buf;

	iconFontName = iconFont.lfFaceName;
	if (isKorean) {
		_tcscpy(dispName, iconFontName.c_str());
		getKoreanFontName(dispName);
		iconFontName = dispName;
	}
	point = getFontPointInt(&iconFont, this->getHwnd());
	_stprintf(buf, _T(" %3dpt"), point);
	iconFontName = iconFontName + buf;

	paletteFontName = metrics.lfSmCaptionFont.lfFaceName;
	if (isKorean) {
		_tcscpy(dispName, paletteFontName.c_str());
		getKoreanFontName(dispName);
		paletteFontName = dispName;
	}
	point = getFontPointInt(&metrics.lfSmCaptionFont, this->getHwnd());
	_stprintf(buf, _T(" %3dpt"), point);
	paletteFontName = paletteFontName + buf;

	hintFontName = metrics.lfStatusFont.lfFaceName;
	if (isKorean) {
		_tcscpy(dispName, hintFontName.c_str());
		getKoreanFontName(dispName);
		hintFontName = dispName;
	}
	point = getFontPointInt(&metrics.lfStatusFont, this->getHwnd());
	_stprintf(buf, _T(" %3dpt"), point);
	hintFontName = hintFontName + buf;

	messageFontName = metrics.lfMessageFont.lfFaceName;
	if (isKorean) {
		_tcscpy(dispName, messageFontName.c_str());
		getKoreanFontName(dispName);
		messageFontName = dispName;
	}
	point = getFontPointInt(&metrics.lfMessageFont, this->getHwnd());
	_stprintf(buf, _T(" %3dpt"), point);
	messageFontName = messageFontName + buf;

	// j[ƑI
	menuFontName = metrics.lfMenuFont.lfFaceName;
	if (isKorean) {
		_tcscpy(dispName, menuFontName.c_str());
		getKoreanFontName(dispName);
		menuFontName = dispName;
	}
	point = getFontPointInt(&metrics.lfMenuFont, this->getHwnd());
	_stprintf(buf, _T(" %3dpt"), point);
	menuFontName = menuFontName + buf;

	UpdateData(false);


	// ItHgeLXg{bNXɐݒ肷B
	if (allFont != NULL) {
		DeleteObject(allFont);
	}
	allFont = createFont(&metricsAll.lfMenuFont);
	allFontTextBox->setFont(allFont);

	if (titleFont != NULL) {
		DeleteObject(titleFont);
	}
	titleFont = createFont(&metrics.lfCaptionFont);
	titleFontTextBox->setFont(titleFont);

	if (iconFontHandle != NULL) {
		DeleteObject(iconFontHandle);
	}
	iconFontHandle = createFont(&iconFont);
	iconFontTextBox->setFont(iconFontHandle);

	if (paletteFont != NULL) {
		DeleteObject(paletteFont);
	}
	paletteFont = createFont(&metrics.lfSmCaptionFont);
	paletteFontTextBox->setFont(paletteFont);

	if (hintFont != NULL) {
		DeleteObject(hintFont);
	}
	hintFont = createFont(&metrics.lfStatusFont);
	hintFontTextBox->setFont(hintFont);

	if (messageFont != NULL) {
		DeleteObject(messageFont);
	}
	messageFont = createFont(&metrics.lfMessageFont);
	messageFontTextBox->setFont(messageFont);

	if (menuFont != NULL) {
		DeleteObject(menuFont);
	}
	menuFont = createFont(&metrics.lfMenuFont);
	menuFontTextBox->setFont(menuFont);

}

/**
 * eɑ΂鏈̕
 *
 * @param wParam WPARAM
 * @return 0:bZ[WB 0ȊO:bZ[WȂB
 */
INT_PTR NoMeiryoUI::OnCommand(WPARAM wParam)
{
	INT_PTR result;

	switch (LOWORD(wParam)) {
		case ID_SEL_ALL:
			selectFont(all);
			return (INT_PTR)0;
		case ID_SEL_TITLE:
			selectFont(title);
			return (INT_PTR)0;
		case ID_SEL_ICON:
			selectFont(icon);
			return (INT_PTR)0;
		case ID_SEL_PALETTE:
			selectFont(palette);
			return (INT_PTR)0;
		case ID_SEL_HINT:
			selectFont(hint);
			return (INT_PTR)0;
		case ID_SEL_MESSAGE:
			selectFont(message);
			return (INT_PTR)0;
		case ID_SEL_MENU:
			selectFont(menu);
			return (INT_PTR)0;
		case ID_SET_ALL:
			OnBnClickedAll();
			EndDialog(hWnd, LOWORD(wParam));
			return BaseDialog::OnCommand(wParam);
		case ID_APPLY_ALL:
			OnBnClickedAll();
			return (INT_PTR)0;
		case IDM_OPEN:
			OnLoad();
			return (INT_PTR)0;
		case IDM_SAVE:
			OnSave();
			return (INT_PTR)0;
		case IDOK:
			result = OnBnClickedOk();
			if (!result) {
				return (INT_PTR)0;
			}
			break;
		case IDM_EXIT:
			EndDialog(hWnd, LOWORD(wParam));
			break;
		case ID_APPLY:
			result = OnBnClickedOk();
			if (!result) {
				return (INT_PTR)0;
			}
			break;
		case IDM_SET_8:
			OnSet8();
			return (INT_PTR)0;
		case IDM_SET_10:
			OnSet10();
			return (INT_PTR)0;
		case IDM_ANOTHER:
			if (appMenu->isChecked(IDM_ANOTHER)) {
				appMenu->CheckMenuItem(IDM_ANOTHER, false);
			} else {
				appMenu->CheckMenuItem(IDM_ANOTHER, true);
			}
			return (INT_PTR)0;
		case IDM_COMPAT7:
			if (appMenu->isChecked(IDM_COMPAT7)) {
				appMenu->CheckMenuItem(IDM_COMPAT7, false);
				WIN8_SIZE = true;
			} else {
				appMenu->CheckMenuItem(IDM_COMPAT7, true);
				WIN8_SIZE = false;
			}
			updateDisplay();

			return (INT_PTR)0;
		case IDM_HELPTOPIC:
			showHelp();
			return (INT_PTR)0;
		case IDM_ABOUT:
			showVersion();
			return (INT_PTR)0;
	}
	return BaseDialog::OnCommand(wParam);

}

/**
 * tHgIB
 *
 * @param type ݒ肷tHg̎
 */
void NoMeiryoUI::selectFont(enum fontType type)
{

	INT_PTR result;
	LOGFONT logfont;	// 擾tHg̏\

	FillMemory(&logfont,sizeof(LOGFONT),0x00);
	
	try {
		LOGFONT *target;
		switch (type) {
			case all:
				target = &metricsAll.lfMenuFont;
				break;

			case title:
				target = &metrics.lfCaptionFont;
				break;

			case icon:
				target = &iconFont;
				break;

			case palette:
				target = &metrics.lfSmCaptionFont;
				break;

			case hint:
				target = &metrics.lfStatusFont;
				break;

			case message:
				target = &metrics.lfMessageFont;
				break;

			case menu:
				// j[ƑI
				target = &metrics.lfMenuFont;
				break;
		}

		FontSel *selector = new FontSel(this->hWnd, IDD_DIALOG_FONTSEL);
		if (noMeiryoUI) {
			selector->setNoMeiryoUI();
		}
		if (noTahoma) {
			selector->setNoTahoma();
		}
		// IĂtHgtHgI_CAOɐݒ肷B
		selector->setPreviousFont(target);

		result = selector->showModal();
		if (result != IDOK){
			delete []selector;
			return;
		}
		logfont = selector->getSelectedFont();
		if (logfont.lfFaceName[0] == _T('\0')) {
			delete []selector;
			return;
		}

		delete []selector;
	} catch (...) {
		MessageBox(this->hWnd,
			_T("Internal error in font selection dialog."),
			_T("Error"),
			MB_OK | MB_ICONEXCLAMATION);
		return;
	}

	switch (type) {
		case all:
			metricsAll.lfMenuFont = logfont;
			metricsAll.lfStatusFont = logfont;
			metricsAll.lfMessageFont = logfont;
			metricsAll.lfCaptionFont = logfont;
			metricsAll.lfSmCaptionFont = logfont;
			iconFontAll = logfont;

			allFontName = logfont.lfFaceName;

			DeleteObject(allFont);
			allFont = createFont(&metricsAll.lfMenuFont);
			allFontTextBox->setFont(allFont);

			break;

		case title:
			metrics.lfCaptionFont = logfont;
			titleFontName = logfont.lfFaceName;

			DeleteObject(titleFont);
			titleFont = createFont(&metrics.lfCaptionFont);
			titleFontTextBox->setFont(titleFont);
			break;

		case icon:
			iconFont = logfont;
			iconFontName = logfont.lfFaceName;

			DeleteObject(iconFontHandle);
			iconFontHandle = createFont(&iconFont);
			iconFontTextBox->setFont(iconFontHandle);
			break;

		case palette:
			metrics.lfSmCaptionFont = logfont;
			paletteFontName = logfont.lfFaceName;

			DeleteObject(paletteFont);
			paletteFont = createFont(&metrics.lfSmCaptionFont);
			paletteFontTextBox->setFont(paletteFont);
			break;

		case hint:
			metrics.lfStatusFont = logfont;
			hintFontName = logfont.lfFaceName;

			DeleteObject(hintFont);
			hintFont = createFont(&metrics.lfStatusFont);
			hintFontTextBox->setFont(hintFont);
			break;

		case message:
			metrics.lfMessageFont = logfont;
			messageFontName = logfont.lfFaceName;

			DeleteObject(messageFont);
			messageFont = createFont(&metrics.lfMessageFont);
			messageFontTextBox->setFont(messageFont);
			break;

		case menu:
			// j[ƑI
			metrics.lfMenuFont = logfont;
			menuFontName = logfont.lfFaceName;

			DeleteObject(menuFont);
			menuFont = createFont(&metrics.lfMenuFont);
			menuFontTextBox->setFont(menuFont);
			break;
	}

	// \XVB
	updateDisplay();
}

/**
 * t@C_CAOp̃t@C}XN쐬
 *
 * @param t@C}XNobt@
 * @param t@C̎ޖ
 * @param t@C̃}XN
 * @param ׂẴt@C̎ޖ
 * @param ׂẴt@C̃}XN
 */
void setFileMask(
	TCHAR *buf,
	const TCHAR *fileMsg,
	const TCHAR *fileExt,
	const TCHAR *allMsg,
	const TCHAR *allExt)
{
	TCHAR *pDst = buf;
	int len;

	len = _tcslen(fileMsg);
	for (int i = 0; i < len; i++) {
		*pDst = fileMsg[i];
		pDst++;
	}
	*pDst = _T('\0');
	pDst++;

	len = _tcslen(fileExt);
	for (int i = 0; i < len; i++) {
		*pDst = fileExt[i];
		pDst++;
	}
	*pDst = _T('\0');
	pDst++;

	len = _tcslen(allMsg);
	for (int i = 0; i < len; i++) {
		*pDst = allMsg[i];
		pDst++;
	}
	*pDst = _T('\0');
	pDst++;

	len = _tcslen(allExt);
	for (int i = 0; i < len; i++) {
		*pDst = allExt[i];
		pDst++;
	}
	*pDst = _T('\0');
	pDst++;

	*pDst = _T('\0');
	pDst++;
}


/**
 * tHgݒۑI̓
 */
void NoMeiryoUI::OnLoad()
{
	TCHAR buf[128];

	if (useResource) {
		setFileMask(
			buf,
			langResource[59].c_str(),
			_T("*.ini"),
			langResource[60].c_str(),
			_T("*.*")
		);
	} else {
		setFileMask(
			buf,
			_T("ݒt@C"),
			_T("*.ini"),
			_T("ׂẴt@C"),
			_T("*.*")
		);
	}

	NCFileDialog *dlg = new NCFileDialog(
		TRUE,
		NULL,
		NULL,
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		buf,
		this->getHwnd(),
		0);

	int result = dlg->DoModal();
	if (result != IDOK) {
		delete dlg;
		return;
	}

	BOOL loadResult;
	loadResult = loadFontInfo(dlg->GetPathName());
	if (!loadResult) {
		const TCHAR *message;
		const TCHAR *title;

		if (useResource) {
			message = langResource[61].c_str();
			title = langResource[63].c_str();
		} else {
			message = _T("tHgݒ̓ǂݍ݂Ɏs܂B");
			title = _T("G[");
		}
		MessageBox(
			this->getHwnd(),
			message,
			title,
			MB_OK | MB_ICONEXCLAMATION);
	} else {
		// tHgݒ̓ǂݍ݂ɐeLXg{bNXɐݒ肷B
		updateDisplay();
	}


	delete dlg;
}

/**
 * tHgǂݍށB
 *
 * @param filename init@C
 * @result TRUE:ۑ FALSE:ۑs
 */
BOOL NoMeiryoUI::loadFontInfo(TCHAR *filename)
{
	BOOL loadResult;
	LOGFONT captionFont;
	LOGFONT newIconFont;
	LOGFONT smCaptionFont;
	LOGFONT statusFont;
	LOGFONT messageFont;
	LOGFONT menuFont;

	loadResult = loadFont(filename, _T("TitleFont"), &captionFont);
	if (!loadResult) {
		return FALSE;
	}
	loadResult = loadFont(filename, _T("IconFont"), &newIconFont);
	if (!loadResult) {
		return FALSE;
	}
	loadResult = loadFont(filename, _T("PaletteFont"), &smCaptionFont);
	if (!loadResult) {
		return FALSE;
	}
	loadResult = loadFont(filename, _T("HintFont"), &statusFont);
	if (!loadResult) {
		return FALSE;
	}
	loadResult = loadFont(filename, _T("MessageFont"), &messageFont);
	if (!loadResult) {
		return FALSE;
	}
	loadResult = loadFont(filename, _T("MenuFont"), &menuFont);
	if (!loadResult) {
		return FALSE;
	}

	metrics.lfCaptionFont = captionFont;
	iconFont = newIconFont;
	metrics.lfSmCaptionFont = smCaptionFont;
	metrics.lfStatusFont = statusFont;
	metrics.lfMessageFont = messageFont;
	metrics.lfMenuFont = menuFont;

	return TRUE;
}

/**
 * tHgǂݍށB
 *
 * @param filename init@C
 * @param category ǂݍݑΏۃtHginit@CZNV
 * @param font ǂݍݑΏۃtHgLOGFONT\
 * @result TRUE:ǂݍݐ FALSE:ǂݍݎs
 */
BOOL NoMeiryoUI::loadFont(TCHAR *filename, TCHAR *section, LOGFONT *font)
{
	TCHAR buf[32];
	DWORD result;

	result = GetPrivateProfileString(section,
		_T("FaceName"),
		_T(""),
		font->lfFaceName,
		32,
		filename);
	if (!result) {
		return FALSE;
	}

	result = GetPrivateProfileString(section,
		_T("Height"),
		_T(""),
		buf,
		32,
		filename);
	if (!result) {
		return FALSE;
	}
	font->lfHeight = _ttoi(buf);

	result = GetPrivateProfileString(section,
		_T("Width"),
		_T(""),
		buf,
		32,
		filename);
	if (!result) {
		return FALSE;
	}
	font->lfWidth = _ttoi(buf);

	result = GetPrivateProfileString(section,
		_T("Escapement"),
		_T(""),
		buf,
		32,
		filename);
	if (!result) {
		return FALSE;
	}
	font->lfEscapement = _ttoi(buf);

	result = GetPrivateProfileString(section,
		_T("Orientation"),
		_T(""),
		buf,
		32,
		filename);
	if (!result) {
		return FALSE;
	}
	font->lfOrientation = _ttoi(buf);

	result = GetPrivateProfileString(section,
		_T("Weight"),
		_T(""),
		buf,
		32,
		filename);
	if (!result) {
		return FALSE;
	}
	font->lfWeight = _ttoi(buf);

	result = GetPrivateProfileString(section,
		_T("Italic"),
		_T(""),
		buf,
		32,
		filename);
	if (!result) {
		return FALSE;
	}
	font->lfItalic = _ttoi(buf);

	result = GetPrivateProfileString(section,
		_T("Underline"),
		_T(""),
		buf,
		32,
		filename);
	if (!result) {
		return FALSE;
	}
	font->lfUnderline = _ttoi(buf);

	result = GetPrivateProfileString(section,
		_T("StrikeOut"),
		_T(""),
		buf,
		32,
		filename);
	if (!result) {
		return FALSE;
	}
	font->lfStrikeOut = _ttoi(buf);

	result = GetPrivateProfileString(section,
		_T("CharSet"),
		_T(""),
		buf,
		32,
		filename);
	if (!result) {
		return FALSE;
	}
	font->lfCharSet = _ttoi(buf);

	result = GetPrivateProfileString(section,
		_T("OutPrecision"),
		_T(""),
		buf,
		32,
		filename);
	if (!result) {
		return FALSE;
	}
	font->lfOutPrecision = _ttoi(buf);

	result = GetPrivateProfileString(section,
		_T("ClipPrecision"),
		_T(""),
		buf,
		32,
		filename);
	if (!result) {
		return FALSE;
	}
	font->lfClipPrecision = _ttoi(buf);

	result = GetPrivateProfileString(section,
		_T("Quality"),
		_T(""),
		buf,
		32,
		filename);
	if (!result) {
		return FALSE;
	}
	font->lfQuality = _ttoi(buf);

	result = GetPrivateProfileString(section,
		_T("PitchAndFamily"),
		_T(""),
		buf,
		32,
		filename);
	if (!result) {
		return FALSE;
	}
	font->lfPitchAndFamily = _ttoi(buf);

	return TRUE;
}


/**
 * tHgݒۑI̓
 */
void NoMeiryoUI::OnSave()
{
	TCHAR buf[128];

	if (useResource) {
		setFileMask(
			buf,
			langResource[59].c_str(),
			_T("*.ini"),
			langResource[60].c_str(),
			_T("*.*")
		);
	} else {
		setFileMask(
			buf,
			_T("ݒt@C"),
			_T("*.ini"),
			_T("ׂẴt@C"),
			_T("*.*")
		);
	}

	NCFileDialog *dlg = new NCFileDialog(
		FALSE,
		NULL,
		NULL,
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		buf,
		this->getHwnd(),
		0);

	int result = dlg->DoModal();
	if (result != IDOK) {
		delete dlg;
		return;
	}

	BOOL saveResult;
	saveResult = startSaveFont(dlg->GetPathName());
	if (!saveResult) {
		const TCHAR *message;
		const TCHAR *title;

		if (useResource) {
			message = langResource[62].c_str();
			title = langResource[63].c_str();
		} else {
			message = _T("tHgݒ̕ۑɎs܂B");
			title = _T("G[");
		}
		MessageBox(
			this->getHwnd(),
			message,
			title,
			MB_OK | MB_ICONEXCLAMATION);
	}


	delete dlg;
}

/**
 * tHgۑJnB
 *
 * @param filename init@C
 * @result TRUE:ۑ FALSE:ۑs
 */
BOOL NoMeiryoUI::startSaveFont(TCHAR *filename)
{
	BOOL saveResult;

	saveResult = saveFont(filename, _T("TitleFont"), &metrics.lfCaptionFont);
	if (!saveResult) {
		return FALSE;
	}
	saveResult = saveFont(filename, _T("IconFont"), &iconFont);
	if (!saveResult) {
		return FALSE;
	}
	saveResult = saveFont(filename, _T("PaletteFont"), &metrics.lfSmCaptionFont);
	if (!saveResult) {
		return FALSE;
	}
	saveResult = saveFont(filename, _T("HintFont"), &metrics.lfStatusFont);
	if (!saveResult) {
		return FALSE;
	}
	saveResult = saveFont(filename, _T("MessageFont"), &metrics.lfMessageFont);
	if (!saveResult) {
		return FALSE;
	}
	saveResult = saveFont(filename, _T("MenuFont"), &metrics.lfMenuFont);
	if (!saveResult) {
		return FALSE;
	}

	return TRUE;
}

/**
 * tHgۑB
 *
 * @param filename init@C
 * @param category ۑΏۃtHginit@CZNV
 * @param font ۑΏۃtHgLOGFONT\
 * @result TRUE:ۑ FALSE:ۑs
 */
BOOL NoMeiryoUI::saveFont(TCHAR *filename, TCHAR *section, LOGFONT *font)
{
	TCHAR buf[32];
	BOOL result;

	result = WritePrivateProfileString(section,
		_T("FaceName"),
		font->lfFaceName,
		filename);
	if (!result) {
		return FALSE;
	}

	_stprintf(buf, _T("%ld"), font->lfHeight);
	result = WritePrivateProfileString(section,
		_T("Height"),
		buf,
		filename);
	if (!result) {
		return FALSE;
	}

	_stprintf(buf, _T("%ld"), font->lfWidth);
	result = WritePrivateProfileString(section,
		_T("Width"),
		buf,
		filename);
	if (!result) {
		return FALSE;
	}

	_stprintf(buf, _T("%ld"), font->lfEscapement);
	result = WritePrivateProfileString(section,
		_T("Escapement"),
		buf,
		filename);
	if (!result) {
		return FALSE;
	}

	_stprintf(buf, _T("%ld"), font->lfOrientation);
	result = WritePrivateProfileString(section,
		_T("Orientation"),
		buf,
		filename);
	if (!result) {
		return FALSE;
	}

	_stprintf(buf, _T("%ld"), font->lfWeight);
	result = WritePrivateProfileString(section,
		_T("Weight"),
		buf,
		filename);
	if (!result) {
		return FALSE;
	}

	_stprintf(buf, _T("%ld"), font->lfItalic);
	result = WritePrivateProfileString(section,
		_T("Italic"),
		buf,
		filename);
	if (!result) {
		return FALSE;
	}

	_stprintf(buf, _T("%ld"), font->lfUnderline);
	result = WritePrivateProfileString(section,
		_T("Underline"),
		buf,
		filename);
	if (!result) {
		return FALSE;
	}

	_stprintf(buf, _T("%ld"), font->lfStrikeOut);
	result = WritePrivateProfileString(section,
		_T("StrikeOut"),
		buf,
		filename);
	if (!result) {
		return FALSE;
	}

	_stprintf(buf, _T("%ld"), font->lfCharSet);
	result = WritePrivateProfileString(section,
		_T("CharSet"),
		buf,
		filename);
	if (!result) {
		return FALSE;
	}

	_stprintf(buf, _T("%ld"), font->lfOutPrecision);
	result = WritePrivateProfileString(section,
		_T("OutPrecision"),
		buf,
		filename);
	if (!result) {
		return FALSE;
	}

	_stprintf(buf, _T("%ld"), font->lfClipPrecision);
	result = WritePrivateProfileString(section,
		_T("ClipPrecision"),
		buf,
		filename);
	if (!result) {
		return FALSE;
	}

	_stprintf(buf, _T("%ld"), font->lfQuality);
	result = WritePrivateProfileString(section,
		_T("Quality"),
		buf,
		filename);
	if (!result) {
		return FALSE;
	}

	_stprintf(buf, _T("%ld"), font->lfPitchAndFamily);
	result = WritePrivateProfileString(section,
		_T("PitchAndFamily"),
		buf,
		filename);
	if (!result) {
		return FALSE;
	}

	return TRUE;
}

/**
 * OK{^̓(ItHgݒ肷B)
 *
 * @return TRUE:tHgݒ肵Ƃ FALSE:tHgݒLZƂ
 */
INT_PTR NoMeiryoUI::OnBnClickedOk()
{
#if 0
	// ďcptHgw肵Ȃ悤₢킹sB
	bool hasVerticalFont = false;
	if (metrics.lfCaptionFont.lfFaceName[0] == _T('@')) {
		hasVerticalFont = true;
	}
	if (metrics.lfSmCaptionFont.lfFaceName[0] == _T('@')) {
		hasVerticalFont = true;
	}
	if (metrics.lfStatusFont.lfFaceName[0] == _T('@')) {
		hasVerticalFont = true;
	}
	if (metrics.lfMessageFont.lfFaceName[0] == _T('@')) {
		hasVerticalFont = true;
	}
	if (metrics.lfMenuFont.lfFaceName[0] == _T('@')) {
		hasVerticalFont = true;	
	}
	if (iconFont.lfFaceName[0] == _T('@')) {
		hasVerticalFont = true;
	}

	if (hasVerticalFont) {
		int answer = MessageBox(hWnd,
			_T("cptHg(O@Ŏn܂tHg)\nw肳Ă܂낵łH"),
			_T("mF"),
			MB_ICONQUESTION | MB_YESNO);
		if (answer != IDYES) {
			return (INT_PTR)FALSE;
		}
	}
#endif

	// tHgύX{B
	setFont(&metrics, &iconFont);

	return (INT_PTR)TRUE;
}

/**
 * ꊇݒ{^̓(ׂẴtHgőItHgݒ肷B)
 *
 */
void NoMeiryoUI::OnBnClickedAll()
{
#if 0
	// ďcptHgw肵Ȃ悤₢킹sB
	if (metricsAll.lfMenuFont.lfFaceName[0] == _T('@')) {
		int answer = MessageBox(hWnd,
			_T("cptHg(O@Ŏn܂tHg)\nw肳Ă܂낵łH"),
			_T("mF"),
			MB_ICONQUESTION | MB_YESNO);
		if (answer != IDYES) {
			return;
		}
	}
#endif

	// tHgύX{B
	setFont(&metricsAll, &iconFontAll);

	memcpy(&metrics, &metricsAll,sizeof(NONCLIENTMETRICS));
	memcpy(&iconFont, &iconFontAll,sizeof(LOGFONT));

	// \XVB
	updateDisplay();
}

/**
 * VXeDPI擾B
 *
 * @return 擾DPI
 */
int NoMeiryoUI::getDPI(void)
{
	// DPI擾B
	int dpiY = 96;
	HDC hdc = GetDC(NULL);

	if (hdc) {
		dpiY = GetDeviceCaps(hdc, LOGPIXELSY);
		ReleaseDC(NULL, hdc);
	}

	return dpiY;
}

/**
 * Windows 8/8.1̏ꍇ̃vZbglݒ肷B
 */
void NoMeiryoUI::OnSet8(void)
{
	// DPI擾B
	int dpiY = getDPI();

	// tHgȊONONCLIENTMETRICŠݒlێ邽߁A
	// NONCLIENTMETRICS̓e擾ȂB
	FillMemory(&metrics,sizeof(NONCLIENTMETRICS),0x00);
	metrics.cbSize = sizeof(NONCLIENTMETRICS);
	SystemParametersInfo(SPI_GETNONCLIENTMETRICS,
		sizeof(NONCLIENTMETRICS),
		&metrics,
		0);

	memset(&metrics.lfCaptionFont, 0, sizeof(LOGFONTW));
	_tcscpy(metrics.lfCaptionFont.lfFaceName, fontFaces8[0].c_str());
	metrics.lfCaptionFont.lfHeight = -MulDiv(fontSizes8[0],dpiY,72);
	metrics.lfCaptionFont.lfWeight = 400;
	metrics.lfCaptionFont.lfCharSet = fontCharset8[0];
	metrics.lfCaptionFont.lfQuality = 5;

	memset(&iconFont, 0, sizeof(LOGFONTW));
	_tcscpy(iconFont.lfFaceName, fontFaces8[1].c_str());
	iconFont.lfHeight = -MulDiv(fontSizes8[1], dpiY, 72);
	iconFont.lfWeight = 400;
	iconFont.lfCharSet = fontCharset8[1];
	iconFont.lfQuality = 5;

	memset(&metrics.lfSmCaptionFont, 0, sizeof(LOGFONTW));
	_tcscpy(metrics.lfSmCaptionFont.lfFaceName, fontFaces8[2].c_str());
	metrics.lfSmCaptionFont.lfHeight = -MulDiv(fontSizes8[2], dpiY, 72);
	metrics.lfSmCaptionFont.lfWeight = 400;
	metrics.lfSmCaptionFont.lfCharSet = fontCharset8[2];
	metrics.lfSmCaptionFont.lfQuality = 5;

	memset(&metrics.lfStatusFont, 0, sizeof(LOGFONTW));
	_tcscpy(metrics.lfStatusFont.lfFaceName, fontFaces8[3].c_str());
	metrics.lfStatusFont.lfHeight = -MulDiv(fontSizes8[3], dpiY, 72);
	metrics.lfStatusFont.lfWeight = 400;
	metrics.lfStatusFont.lfCharSet = fontCharset8[3];
	metrics.lfStatusFont.lfQuality = 5;

	memset(&metrics.lfMessageFont, 0, sizeof(LOGFONTW));
	_tcscpy(metrics.lfMessageFont.lfFaceName, fontFaces8[4].c_str());
	metrics.lfMessageFont.lfHeight = -MulDiv(fontSizes8[4], dpiY, 72);
	metrics.lfMessageFont.lfWeight = 400;
	metrics.lfMessageFont.lfCharSet = fontCharset8[4];
	metrics.lfMessageFont.lfQuality = 5;

	memset(&metrics.lfMenuFont, 0, sizeof(LOGFONTW));
	_tcscpy(metrics.lfMenuFont.lfFaceName, fontFaces8[5].c_str());
	metrics.lfMenuFont.lfHeight = -MulDiv(fontSizes8[5], dpiY, 72);
	metrics.lfMenuFont.lfWeight = 400;
	metrics.lfMenuFont.lfCharSet = fontCharset8[5];
	metrics.lfMenuFont.lfQuality = 5;

	// \XVB
	updateDisplay();

}

/**
 * Windows 10̏ꍇ̃vZbglݒ肷B
 */
void NoMeiryoUI::OnSet10(void)
{
	// DPI擾B
	int dpiY = getDPI();

	// tHgȊONONCLIENTMETRICŠݒlێ邽߁A
	// NONCLIENTMETRICS̓e擾ȂB
	FillMemory(&metrics, sizeof(NONCLIENTMETRICS), 0x00);
	metrics.cbSize = sizeof(NONCLIENTMETRICS);
	SystemParametersInfo(SPI_GETNONCLIENTMETRICS,
		sizeof(NONCLIENTMETRICS),
		&metrics,
		0);

	memset(&metrics.lfCaptionFont, 0, sizeof(LOGFONTW));
	_tcscpy(metrics.lfCaptionFont.lfFaceName, fontFaces10[0].c_str());
	metrics.lfCaptionFont.lfHeight = -MulDiv(fontSizes10[0], dpiY, 72);
	metrics.lfCaptionFont.lfWeight = 400;
	metrics.lfCaptionFont.lfCharSet = fontCharset10[0];
	metrics.lfCaptionFont.lfQuality = 5;

	memset(&iconFont, 0, sizeof(LOGFONTW));
	_tcscpy(iconFont.lfFaceName, fontFaces10[1].c_str());
	iconFont.lfHeight = -MulDiv(fontSizes10[1], dpiY, 72);
	iconFont.lfWeight = 400;
	iconFont.lfCharSet = fontCharset10[1];
	iconFont.lfQuality = 5;

	memset(&metrics.lfSmCaptionFont, 0, sizeof(LOGFONTW));
	_tcscpy(metrics.lfSmCaptionFont.lfFaceName, fontFaces10[2].c_str());
	metrics.lfSmCaptionFont.lfHeight = -MulDiv(fontSizes10[2], dpiY, 72);
	metrics.lfSmCaptionFont.lfWeight = 400;
	metrics.lfSmCaptionFont.lfCharSet = fontCharset10[2];
	metrics.lfSmCaptionFont.lfQuality = 5;

	memset(&metrics.lfStatusFont, 0, sizeof(LOGFONTW));
	_tcscpy(metrics.lfStatusFont.lfFaceName, fontFaces10[3].c_str());
	metrics.lfStatusFont.lfHeight = -MulDiv(fontSizes10[3], dpiY, 72);
	metrics.lfStatusFont.lfWeight = 400;
	metrics.lfStatusFont.lfCharSet = fontCharset10[3];
	metrics.lfStatusFont.lfQuality = 5;

	memset(&metrics.lfMessageFont, 0, sizeof(LOGFONTW));
	_tcscpy(metrics.lfMessageFont.lfFaceName, fontFaces10[4].c_str());
	metrics.lfMessageFont.lfHeight = -MulDiv(fontSizes10[4], dpiY, 72);
	metrics.lfMessageFont.lfWeight = 400;
	metrics.lfMessageFont.lfCharSet = fontCharset10[4];
	metrics.lfMessageFont.lfQuality = 5;

	memset(&metrics.lfMenuFont, 0, sizeof(LOGFONTW));
	_tcscpy(metrics.lfMenuFont.lfFaceName, fontFaces10[5].c_str());
	metrics.lfMenuFont.lfHeight = -MulDiv(fontSizes10[5], dpiY, 72);
	metrics.lfMenuFont.lfWeight = 400;
	metrics.lfMenuFont.lfCharSet = fontCharset10[5];
	metrics.lfMenuFont.lfQuality = 5;

	// \XVB
	updateDisplay();

}

// ݒ肷VXetHg̏i[p\
// VXetHgݒXbhŎgpB
NONCLIENTMETRICS *s_fontMetrics;

/**
 * XbhŃACRȊÕtHgݒ肷B
 *
 * @param p Xbhɓnp[^(gp)
 * @return 0
 */
unsigned _stdcall setOnThread(void *p)
{
	DWORD_PTR ptr;
	LRESULT messageResult;

	SystemParametersInfo(SPI_SETNONCLIENTMETRICS,
		sizeof(NONCLIENTMETRICS),
		s_fontMetrics,
		SPIF_UPDATEINIFILE); // | SPIF_SENDCHANGE);

	return 0;
}


/**
 * ʊẽtHgݒ肷B
 *
 * @param fontMetrics ACRȊÕtHgwpNONCLIENTMETRICS
 * @param iconLogFont ACR̃tHg
 */
void NoMeiryoUI::setFont(
	NONCLIENTMETRICS *fontMetrics,
	LOGFONT *iconLogFont
) {

	DWORD_PTR ptr;
	LRESULT messageResult;

	// ACR̃tHgݒ
	SystemParametersInfo(SPI_SETICONTITLELOGFONT,
		sizeof(LOGFONT),
		iconLogFont,
		SPIF_UPDATEINIFILE); // | SPIF_SENDCHANGE);

	messageResult = SendMessageTimeout(
		HWND_BROADCAST,
		WM_SETTINGCHANGE,
		SPI_SETICONTITLELOGFONT,
		0, // (LPARAM)_T("Environment"),
		SMTO_ABORTIFHUNG,
		5000,
		&ptr);
	if (messageResult == 0) {
		if (GetLastError() == ERROR_TIMEOUT) {
			MessageBox(this->getHwnd(), 
				_T("SendMessage timeout."),
				_T("Information"),
				MB_OK | MB_ICONEXCLAMATION);
		}
	}

	// ACRȊÕtHgݒ
	if (appMenu->isChecked(IDM_ANOTHER)) {
		// UIƕʃXbhSystemParametersInfo(SPI_SETNONCLIENTMETRICS
		// sB
		s_fontMetrics = fontMetrics;

		// tHgݒsXbhJnB
		uintptr_t startResult = _beginthreadex(NULL, 0, setOnThread, NULL, 0, NULL);
		if (startResult != 0) {
			// ɃXbhJnXbhIҋ@B
			HANDLE handle;
			handle = (HANDLE)startResult;

			// ꉞ5bقǑ҂
			DWORD waitResult = WaitForSingleObject(handle, 5000);
			if (waitResult == WAIT_TIMEOUT) {
				// XbhIȂꍇ͂ǂ悤Ȃ̂ŃXbhIB
				TerminateThread(handle, 0);
			}
			CloseHandle(handle);
		}
	} else {
		// UIƓXbhSystemParametersInfo(SPI_SETNONCLIENTMETRICS
		// sB
		SystemParametersInfo(SPI_SETNONCLIENTMETRICS,
			sizeof(NONCLIENTMETRICS),
			fontMetrics,
			SPIF_UPDATEINIFILE); // | SPIF_SENDCHANGE);
	}

	messageResult = SendMessageTimeout(
		HWND_BROADCAST,
		WM_SETTINGCHANGE,
		SPI_SETNONCLIENTMETRICS,
		(LPARAM)_T("WindowMetrics"),
		SMTO_ABORTIFHUNG,
		5000,
		&ptr);
	if (messageResult == 0) {
		if (GetLastError() == ERROR_TIMEOUT) {
			MessageBox(this->getHwnd(), 
				_T("SendMessage timeout."),
				_T("Information"),
				MB_OK | MB_ICONEXCLAMATION);
		}
	}

	// FĐݒ肷邱ƂŉʂtbVB
	// ̂AIObit StartMenu 8NĂƂSetSysColors
	// ĂяoƉȂȂ̂ŌĂяosȂƂɂB
#if 0
	DWORD btnColor;
	btnColor = GetSysColor(COLOR_BTNTEXT);

	INT colorItems[1];
	colorItems[0] = COLOR_BTNTEXT;
	COLORREF colors[1];
	colors[0] = btnColor;
	SetSysColors(1,colorItems,colors);
#endif

}

/**
 * Windows̃o[W擾āAʂɐݒ肷B
 */
void NoMeiryoUI::SetWinVer(void)
{
	// Windows̓o[W𒲂ׂB
	DWORD dwVersion = GetVersion();
	TCHAR buf[128];

	DWORD major = (DWORD)(LOBYTE(LOWORD(dwVersion)));
	DWORD minor = (DWORD)(HIBYTE(LOWORD(dwVersion)));

	// T[o[ǂ̒ǉ擾邽
	// GetVersionExOSVERSIONINFOEXnČĂяoB
	// Windows 98/Me,NT4ȑO͍lȂ̂ŌĂѕ͂ȂB
	OSVERSIONINFOEX infoEx;
	memset(&infoEx, 0, sizeof(OSVERSIONINFOEX));
	infoEx.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);
	GetVersionEx((OSVERSIONINFO *)&infoEx);

	switch(major) {
		case 5:
			switch (minor) {
				case 0:
					_stprintf(buf,
						_T("Windows Version:Windows 2000 (%d.%d)"),
						major,minor);
					break;
				case 1:
					_stprintf(buf,
						_T("Windows Version:Windows XP (%d.%d)"),
						major,minor);
					break;
				case 2:
					if (infoEx.wProductType == VER_NT_WORKSTATION) {
						_stprintf(buf,
							_T("Windows Version:Windows XP 64bit (%d.%d)"),
							major,minor);
					} else {
						_stprintf(buf,
							_T("Windows Version:Windows Server 2003 (%d.%d)"),
							major,minor);
					}
					break;
			}
			break;
		case 6:
			switch (minor) {
				case 0:
					if (infoEx.wProductType == VER_NT_WORKSTATION) {
						_stprintf(buf,
							_T("Windows Version:Windows Vista (%d.%d)"),
							major,minor);
					} else {
						_stprintf(buf,
							_T("Windows Version:Windows Server 2008 (%d.%d)"),
							major,minor);
					}
					break;
				case 1:
					if (infoEx.wProductType == VER_NT_WORKSTATION) {
						_stprintf(buf,
							_T("Windows Version:Windows 7 (%d.%d)"),
							major,minor);
					} else {
						_stprintf(buf,
							_T("Windows Version:Windows Server 2008 R2 (%d.%d)"),
							major,minor);
					}
					break;
				case 2:
					if (infoEx.wProductType == VER_NT_WORKSTATION) {
						_stprintf(buf,
							_T("Windows Version:Windows 8 (%d.%d)"),
							major,minor);
					} else {
						_stprintf(buf,
							_T("Windows Version:Windows Server 2012 (%d.%d)"),
							major,minor);
					}
					break;
				case 3:
					if (infoEx.wProductType == VER_NT_WORKSTATION) {
						_stprintf(buf,
							_T("Windows Version:Windows 8.1 (%d.%d)"),
							major,minor);
					} else {
						_stprintf(buf,
							_T("Windows Version:Windows Server 2012 R2 (%d.%d)"),
							major,minor);
					}
					break;
				default:
					if (infoEx.wProductType == VER_NT_WORKSTATION) {
						_stprintf(buf,
							_T("Windows Version:Future Windows Client (%d.%d)"),
							major,minor);
					} else {
						_stprintf(buf,
							_T("Windows Version:Future Windows Server (%d.%d)"),
							major,minor);
					}
					break;
			}
			break;
		case 10:
			if (infoEx.wProductType == VER_NT_WORKSTATION) {
				getWin10Ver(buf, major, minor);
			} else {
				_stprintf(buf,
					_T("Windows Version:Windows Server 2016/2019 (%d.%d)"),
					major,minor);
			}
			break;
		default:
			if (infoEx.wProductType == VER_NT_WORKSTATION) {
				_stprintf(buf,
					_T("Windows Version:Future Windows Client (%d.%d)"),
					major,minor);
			} else {
				_stprintf(buf,
					_T("Windows Version:Future Windows Server (%d.%d)"),
					major,minor);
			}
			break;
	}

	verInfo = GetDlgItem(IDC_STATIC_VERNO);
	verInfo->setText(buf);
}

/**
 * Windows 10̃o[W擾B
 *
 * @param buf o[Wԍi[
 * @param major W[o[W
 * @param minor }Ci[o[W
 */
void NoMeiryoUI::getWin10Ver(TCHAR *buf, DWORD major, DWORD minor)
{
	TCHAR release[8];
	TCHAR build[8];
	DWORD ubr = 0;

	HKEY key;
	LONG result;
	DWORD size;

	_tcscpy(release, _T("????"));
	_tcscpy(build, _T("?"));

	result = RegOpenKeyEx(HKEY_LOCAL_MACHINE,
		_T("SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion"),
		0, KEY_READ, &key);
	if (result == ERROR_SUCCESS) {
		size = sizeof(TCHAR) * 8;
		RegQueryValueEx(key, _T("ReleaseId"), NULL, NULL, (LPBYTE)release, (LPDWORD)&size);
		size = sizeof(TCHAR) * 8;
		RegQueryValueEx(key, _T("CurrentBuild"), NULL, NULL, (LPBYTE)build, (LPDWORD)&size);
		size = sizeof(DWORD);
		RegQueryValueEx(key, _T("UBR"), NULL, NULL, (LPBYTE)&ubr, (LPDWORD)&size);
		RegCloseKey(key);
	}

	_stprintf(buf,
		_T("Windows Version:Windows 10 (%d.%d) Version %s Build %s.%d"),
		major, minor, release, build, ubr);

}

/**
 * hLgt@C\B
 *
 */
void NoMeiryoUI::showHelp(void)
{
	// st@C̏𓾂邽߂̃obt@Q
	TCHAR path[_MAX_PATH+1],drive[_MAX_DRIVE+1],dir[_MAX_DIR+1],commandLine[_MAX_PATH+32];

	// st@ĈƂBShelp.html̃pX𐶐B
	::GetModuleFileName(NULL,path,_MAX_PATH);
	::_tsplitpath(path,drive,dir,NULL,NULL);
	::_stprintf(commandLine, _T("hh.exe \"%s%s%s\""), drive, dir, helpFileName);
	
	// ֘AtꂽAvŃhLgt@C\B
	// ShellExecute(hWnd,_T("open"),helpFile,NULL,NULL,SW_SHOW);

	// EChEʒu𐧌䂷邽CreateProcessŃwvt@C\
	STARTUPINFO info;
	PROCESS_INFORMATION procInfo;
	BOOL startResult;

	memset(&info, 0, sizeof(STARTUPINFO));
	memset(&procInfo, 0, sizeof(PROCESS_INFORMATION));

	startResult = CreateProcess(
		NULL,
		commandLine,
		NULL,
		NULL,
		FALSE,
		0,
		NULL,
		NULL,
		&info,
		&procInfo
	);
	if (startResult == FALSE) {
		return;
	}
	helpPid = procInfo.dwProcessId;
	helpMoved = false;

	// CEChÊfBXvC̍Wn擾B
	EnumDisplayMonitors(NULL, NULL, MonitorNearWindowCallback, (LPARAM)this->hWnd);

	for (int i = 0; helpMoved == false && i < 25; i++) {
		// NwṽEChEACEChÊfBXvC
		// ɂĂB
		EnumWindows(setWindowSize, 0);
		Sleep(200);
	}

}

/**
 * eEChEɑ΂`FbNsR[obN
 *
 * @param hWnd EChẼnh
 * @param lparam EnumWindowsLPARAM(gp)
 * @return TRUE:񋓂𑱂 FALSE:񋓂IB
 */
BOOL CALLBACK setWindowSize(HWND hWnd, LPARAM lparam)
{
	DWORD wndPid;
	WINDOWPLACEMENT place;
	place.length = sizeof(WINDOWPLACEMENT);

	// NvÕEChET
	GetWindowThreadProcessId(hWnd, &wndPid);
	if (wndPid == helpPid) {
		if (IsWindowVisible(hWnd)) {
			if (IsWindow(hWnd)) {
				// CEChÊfBXvC̒
				// wṽEChEʒuݒ肷B
				adjustCenter(myMonitorLect, HWND_TOP, hWnd);
				helpMoved = true;

				return FALSE;
			}
		}
	}
	return TRUE;
}

/**
 * EChÊ郂j^[𔻒肷邽߂EnumDisplayMonitors̃R[obN
 *
 * @param hMonitor j^[̃nh
 * @param hdcMonitor j^[̃fBXvCReLXg
 * @param lprcMonitor j^[̍W
 * @param dwData EnumDisplayMonitors̃p[^(CEChẼEChEnh)
 * @return TRUE:񋓂𑱂 FALSE:񋓂߁Aj^[̍Wm肳
 */
BOOL CALLBACK MonitorNearWindowCallback(
	HMONITOR hMonitor,
	HDC hdcMonitor,
	LPRECT lprcMonitor,
	LPARAM dwData
)
{
	HWND myHwnd = (HWND)dwData;
	if (!firstMonitor) {
		// fBXvC̏񂪉ȂԂ͔B
		myMonitorLect = *lprcMonitor;
		firstMonitor = true;
	}

	RECT rect;
	GetWindowRect(myHwnd, &rect);

	// J[\̂郂j^ǂ肷B
	int x = rect.left;
	int y = rect.top;
	if ((x >= lprcMonitor->left) && (x <= lprcMonitor->right)) {
		if ((y >= lprcMonitor->top) && (y <= lprcMonitor->bottom)) {
			myMonitorLect = *lprcMonitor;

			return FALSE;
		}
	}
	return TRUE;
}



/**
 * o[Wԍ\B
 *
 */
void NoMeiryoUI::showVersion(void)
{
	TCHAR aboutContent[256];
	TCHAR version[64];
	TCHAR transAuthor[64];
	TCHAR title[64];
	const TCHAR *appName;
	TCHAR verString[32];

	if (useResource) {
		appName = langResource[1].c_str();
		_stprintf(title, _T("%s"),
			langResource[64].c_str());
		_tcscpy(transAuthor, langResource[69].c_str());
	} else {
		appName = _T("Meiryo UI炢!!");
		_stprintf(title, _T("Meiryo UI炢!!ɂ"));
		_tcscpy(transAuthor, _T("Tatsuhiko Syoji(Tatsu)"));
	}
	LoadString(hInst, IDS_VERSION, verString, 32);

	_stprintf(version, verString, appName);
	_stprintf(aboutContent,
		_T("%s\n\nProgrammed By Tatsuhiko Syoji(Tatsu) 2005,2012-2020\nTranslated by %s"),
		version, transAuthor);

	MessageBox(hWnd,
		aboutContent,
		title,
		MB_OK | MB_ICONINFORMATION);
}

