/*
noMeiryoUI (C) 2005,2012-2018 Tatsuhiko Shoji
The sources for noMeiryoUI are distributed under the MIT open source license
*/
#include <stdio.h>
#include <windows.h>
#include <tchar.h>
#include <string.h>

// cl /D "UNICODE" /D "_UNICODE" iniReader.cpp

static bool inSection = false;
static char currentSection[128];
static char valueBuf[256];

/**
 * }`oCg񂩂R[hy[WɍvCh擾B
 *
 * @param returnString i[obt@
 * @param readString ǂݎ
 * @param returnSize i[obt@̃TCY
 * @param codePage ϊ̃R[hy[W
 * @return obt@Ɋi[ꂽ
 */
DWORD getWideString(
	TCHAR *returnString,
	char *readString,
	DWORD returnSize,
	UINT codePage)
{
	int transferCount;
	
	transferCount = MultiByteToWideChar(
		codePage,
		MB_PRECOMPOSED,
		readString,
		-1,
		returnString,
		returnSize);
		
	return transferCount;
}

/**
 * ؂蕶Tċ؂
 *
 * @param start Jnʒu
 * @param delimiter ؂蕶
 * @return NULL:؂蕶̂ꏊ NULL:؂蕶݂Ȃ
 */
char *searchAndDelimit(char *start, char delimiter)
{
	char *currentChar = start;

	while(*currentChar != '\0'){
		if (*currentChar == delimiter) {
			*currentChar = '\0';
			return currentChar;
		}
		currentChar++;
	}
	return NULL;
}


/**
 * ϊ̃R[hy[Wlinit@Cǂݎ
 *
 * @param sectionName ZNV(}`oCgs)
 * @param keyName L[
 * @param defaultValue ̕
 * @param returnString i[obt@
 * @param returnSize i[obt@̃TCY
 * @param iniFileName init@C
 * @param codePage ϊ̃R[hy[W
 * @return obt@Ɋi[ꂽ
 */
DWORD GetPrivateProfileStringExT(
	char *sectionName,
	TCHAR *keyName,
	TCHAR *defaultValue,
	TCHAR *returnString,
	DWORD returnSize,
	TCHAR *iniFileName,
	UINT codePage)
{

	FILE *fp;
	char key[64];
	
	inSection = false;

#if UNICODE
	fp = _wfopen(iniFileName, L"r");
	wcstombs(key, keyName, 64);
#else
	fp = fopen(iniFileName, "r");
	strcpy(key, keyName);
#endif
	if (fp == NULL) {
		_tcsncpy(returnString, defaultValue, returnSize - 1);
		returnString[returnSize - 1] = _T('\0');
		return _tcslen(returnString);
	}
	
	while(fgets(valueBuf, 255, fp) != NULL) {
		/* Skip comment */
		char *firstChar;
		char *currentChar;
		bool isComment = false;

		firstChar = valueBuf;
		while(*firstChar != '\0') {
			if (*firstChar == ';') {
				isComment = true;;
				break;
			} else if (!isspace(*firstChar)){
				if (*firstChar == '[') {
					// New section start
					inSection = false;
				}
				break;
			}
			firstChar++;
		}
		if (isComment) {
			continue;
		}
		if ((*firstChar == '\0') || (*firstChar == '\n')){
			continue;
		}

		/* remove return code */
		searchAndDelimit(firstChar, '\n');

		if (inSection) {
			/* ZNV܂ĂƂ̏ */
			if (strcmp(sectionName, currentSection)) {
				continue;
			} else {
				char *keyDelim = NULL;
				
				keyDelim = searchAndDelimit(firstChar, '=');
				if (keyDelim == NULL) {
					/* no value */
					continue;
				}
				if (strcmp(firstChar, key)) {
					/* Key not matched */
					continue;
				} else {
					return getWideString(returnString, keyDelim + 1, returnSize, codePage);
				}
			}
		} else {
			
			/* Get section name */
			if (valueBuf[0] != '['){
				continue;
			} else {
				char *p;
				p = strchr(valueBuf, ']');
				if (p == NULL) {
					continue;
				} else {
					*p = '\0';
					strcpy(currentSection, valueBuf + 1);
					inSection = true;
				}
			}
		}
	}

	/* L[ƒlȂ */
	_tcsncpy(returnString, defaultValue, returnSize - 1);
	returnString[returnSize - 1] = _T('\0');
	return _tcslen(returnString);

}
